% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remap_gifti.R
\name{remap_gifti}
\alias{remap_gifti}
\title{Remap GIFTI metric or label data}
\usage{
remap_gifti(
  original_fname,
  target_fname,
  hemisphere = c("left", "right"),
  remap_method = c("adaptive", "barycentric"),
  area_original_fname,
  area_target_fname,
  ROIcortex_original_fname,
  ROIcortex_target_fname,
  sphere_original_fname,
  sphere_target_fname
)
}
\arguments{
\item{original_fname}{The GIFTI file to remap.}

\item{target_fname}{Where to save the remapped file.}

\item{hemisphere}{\code{"left"} (default) or \code{"right"}. An error will
occur if the hemisphere indicated in the GIFTI metadata does not match.}

\item{remap_method}{\code{"adaptive"} (default) or \code{"adaptive"}
resampling. These options correspond to the Workbench command options
\code{"BARYCENTRIC"} and \code{"ADAP_BARY_AREA"}, respectively.

For remapping between fs_LR group data and FreeSurfer fsaverage group data,
adaptive resampling should be used.}

\item{area_original_fname, area_target_fname}{File paths to the surfaces to
use for vertex area correction during adaptive resampling. Required if
\code{remap_method} is \code{"adaptive"}.}

\item{ROIcortex_original_fname, ROIcortex_target_fname}{\code{ROIcortex_original_fname} is the name of the ROI file corresponding to
\code{original_fname}. Leave as \code{NULL} (default) if not applicable. If
provided, then also provide \code{ROIcortex_target_fname} to say where to
write the remapped ROI file.}

\item{sphere_original_fname, sphere_target_fname}{File paths to the sphere
surfaces in the original and target spaces.}
}
\value{
The remapped GIFTI file name, invisibly
}
\description{
Remap GIFTI metric or label data between two different spaces, such as
between FreeSurfer fsaverage group data and fs_LR group data. This function
is a wrapper to \code{\link{resample_gifti}}.
}
\section{Connectome Workbench}{

This function interfaces with the \code{"-metric-resample"}, \code{"-label-resample"},
and/or \code{"-surface-resample"} Workbench commands, depending on the input.
}

\seealso{
Other gifting: 
\code{\link{resample_gifti}()},
\code{\link{smooth_gifti}()}
}
\concept{gifting}
