% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_xifti.R
\name{remove_xifti}
\alias{remove_xifti}
\title{Remove a component from a \code{"xifti"}}
\usage{
remove_xifti(xifti, remove = NULL, remove_sub = NULL)
}
\arguments{
\item{xifti}{A \code{"xifti"} object.}

\item{remove}{A character vector containing one or more of the following:
\code{"cortex_left"}, \code{"cortex_right"}, \code{"subcortical"},
\code{"surf_left"}, and \code{"surf_right"}. Each of these components will
be removed from \code{xifti}.}

\item{remove_sub}{A vector containing subcortical structures to be removed
from \code{xifti}. Can be specified with names, or with numeric factor
values: see \code{\link{substructure_table}}.}
}
\value{
The new \code{"xifti"} with the requested component(s) removed
}
\description{
Remove a brain structure, surface, or subcortical structure from a
\code{"xifti"}.
}
\seealso{
Other manipulating xifti: 
\code{\link{add_surf}()},
\code{\link{apply_parc}()},
\code{\link{apply_xifti}()},
\code{\link{combine_xifti}()},
\code{\link{convert_to_dlabel}()},
\code{\link{merge_xifti}()},
\code{\link{move_to_mwall}()},
\code{\link{newdata_xifti}()},
\code{\link{remap_cifti}()},
\code{\link{resample_cifti}()},
\code{\link{resample_cifti_from_template}()},
\code{\link{scale_xifti}()},
\code{\link{select_xifti}()},
\code{\link{set_names_xifti}()},
\code{\link{smooth_cifti}()},
\code{\link{transform_xifti}()}
}
\concept{manipulating xifti}
