% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{as.data.frame.checkglobalsi}
\alias{as.data.frame.checkglobalsi}
\title{Cast to data.frame}
\usage{
\method{as.data.frame}{checkglobalsi}(x, row.names = NULL, optional = FALSE, pattern, ...)
}
\arguments{
\item{x}{object inheriting from class \code{"checkglobalsi"}.}

\item{row.names}{currently not used, included for compatibility with \code{\link{as.data.frame}} generic.}

\item{optional}{currently not used, included for compatibility with \code{\link{as.data.frame}} generic.}

\item{pattern}{an optional \link{regular expression}.  Only names
matching \code{pattern} are returned. \code{\link{glob2rx}} can be
used to convert wildcard patterns to regular expressions.}

\item{...}{additional arguments to configure the output:
\itemize{
\item \code{all.names}, a logical value.  If \code{TRUE}, all object names are returned.
If \code{FALSE}, names which begin with a \samp{.} are omitted. Defaults to \code{TRUE}.
\item \code{sorted}, a logical value indicating if the function/variable names should be sorted alphabetically.
Defaults to \code{TRUE}.
}}
}
\value{
a data.frame similar in format to \code{\link{as.data.frame.checkglobals}}.
}
\description{
Cast an S3-object of class \code{"checkglobalsi"} to a data.frame.
}
\examples{
## R-package from folder
chk <- checkglobals(
  pkg = system.file(
    "unit_tests", "pkg", "testpkg",
    package = "checkglobals"
  )
)
as.data.frame(chk$imports)
}
\seealso{
\code{\link{as.data.frame.checkglobals}}
}
