% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotNormCurves}
\alias{plotNormCurves}
\title{Plot norm curves}
\usage{
plotNormCurves(
  model,
  normList = NULL,
  minAge = NULL,
  maxAge = NULL,
  step = 0.1,
  minRaw = NULL,
  maxRaw = NULL
)
}
\arguments{
\item{model}{The model from the bestModel function, a cnorm object, or a cnormBetaBinomial / cnormBetaBinomial2 object.}

\item{normList}{Vector with norm scores to display. If NULL, default values are used.}

\item{minAge}{Age to start with checking. If NULL, it's automatically determined from the model.}

\item{maxAge}{Upper end of the age check. If NULL, it's automatically determined from the model.}

\item{step}{Stepping parameter for the age check, usually 1 or 0.1; lower scores indicate higher precision.}

\item{minRaw}{Lower end of the raw score range, used for clipping implausible results. If NULL, it's automatically determined from the model.}

\item{maxRaw}{Upper end of the raw score range, used for clipping implausible results. If NULL, it's automatically determined from the model.}
}
\value{
A ggplot object representing the norm curves.
}
\description{
This function plots the norm curves based on the regression model. It supports both
Taylor polynomial models and beta-binomial models.
}
\details{
Please check the function for inconsistent curves: The different curves should not intersect.
Violations of this assumption are a strong indication of violations of model assumptions in
modeling the relationship between raw and norm scores.

Common reasons for inconsistencies include:
1. Vertical extrapolation: Choosing extreme norm scores (e.g., scores <= -3 or >= 3).
2. Horizontal extrapolation: Using the model scores outside the original dataset.
3. The data cannot be modeled with the current approach, or you need another power parameter (k) or R2 for the model.
}
\examples{
\dontrun{
# For Taylor continuous norming model
m <- cnorm(raw = ppvt$raw, group = ppvt$group)
plotNormCurves(m, minAge=2, maxAge=5)

# For beta-binomial model
bb_model <- cnorm.betabinomial(age = ppvt$age, score = ppvt$raw, n = 228)
plotNormCurves(bb_model)
}
}
\seealso{
\code{\link{checkConsistency}}, \code{\link{plotDerivative}}, \code{\link{plotPercentiles}}

Other plot: 
\code{\link{plot.cnorm}()},
\code{\link{plot.cnormBetaBinomial}()},
\code{\link{plot.cnormBetaBinomial2}()},
\code{\link{plotDensity}()},
\code{\link{plotDerivative}()},
\code{\link{plotNorm}()},
\code{\link{plotPercentileSeries}()},
\code{\link{plotPercentiles}()},
\code{\link{plotRaw}()},
\code{\link{plotSubset}()}
}
\concept{plot}
