% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaBinomial.R
\name{betaTable}
\alias{betaTable}
\title{Calculate Cumulative Probabilities, Density, Percentiles, and Z-Scores for
Beta-Binomial Distribution}
\usage{
betaTable(a, b, n, m = NULL)
}
\arguments{
\item{a}{The \eqn{\alpha} parameter of the beta distribution, indicating the shape parameter associated with successes.}

\item{b}{The \eqn{\beta} parameter of the beta distribution, indicating the shape parameter associated with failures.}

\item{n}{The number of trials in the beta-binomial distribution.}

\item{m}{An optional stop criterion in table generation. Positive integer lower than n.}
}
\value{
A data frame with columns:
\describe{
  \item{x}{The number of successes (0 to n).}
  \item{Px}{The density (probability mass function value) for each number of successes.}
  \item{Pcum}{The cumulative probability up to each number of successes.}
  \item{Percentile}{The percentile corresponding to each number of successes.}
  \item{z}{The z-score corresponding to each percentile.}
}
}
\description{
This function computes the cumulative probabilities, the density (probability mass
function values), the percentiles, and the corresponding z-scores based on the specified
parameters of a beta-binomial distribution. The beta-binomial distribution is used to model
the number of successes in a fixed number of trials with success probability varying from
trial to trial, described by beta distribution parameters \eqn{\alpha} (alpha)
and \eqn{\beta} (beta).
}
\details{
The function utilizes the gamma function to calculate factorial terms needed for the probability mass function (PMF)
and cumulative distribution function (CDF) calculations of the beta-binomial distribution. It iterates over the range
of possible successes (0 to n) to compute the PMF values (\eqn{Px}), cumulative probabilities (\eqn{Pcum}), and
mid-percentiles. These percentiles are then used to calculate the corresponding z-scores, which indicate how many
standard deviations an element is from the mean.
}
\examples{
betaTable(2, 2, 45, 20)
}
