% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_distribution.R
\name{poisson_distribution}
\alias{poisson_distribution}
\alias{poisson_pdf}
\alias{poisson_lpdf}
\alias{poisson_cdf}
\alias{poisson_lcdf}
\alias{poisson_quantile}
\title{Poisson Distribution Functions}
\usage{
poisson_pdf(x, lambda = 1)

poisson_lpdf(x, lambda = 1)

poisson_cdf(x, lambda = 1)

poisson_lcdf(x, lambda = 1)

poisson_quantile(p, lambda = 1)
}
\arguments{
\item{x}{quantile}

\item{lambda}{rate parameter (default is 1)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Poisson distribution.
}
\examples{
# Poisson distribution with lambda = 1
poisson_pdf(0, 1)
poisson_lpdf(0, 1)
poisson_cdf(0, 1)
poisson_lcdf(0, 1)
poisson_quantile(0.5, 1)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/poisson_dist.html}{Boost Documentation} for more details on the mathematical background.
}
