% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypergeometric_functions.R
\name{hypergeometric_functions}
\alias{hypergeometric_functions}
\alias{hypergeometric_1F0}
\alias{hypergeometric_0F1}
\alias{hypergeometric_2F0}
\alias{hypergeometric_1F1}
\alias{hypergeometric_1F1_regularized}
\alias{log_hypergeometric_1F1}
\alias{hypergeometric_pFq}
\title{Hypergeometric Functions}
\usage{
hypergeometric_1F0(a, z)

hypergeometric_0F1(b, z)

hypergeometric_2F0(a1, a2, z)

hypergeometric_1F1(a, b, z)

hypergeometric_1F1_regularized(a, b, z)

log_hypergeometric_1F1(a, b, z)

hypergeometric_pFq(a, b, z)
}
\arguments{
\item{a}{Parameter of the hypergeometric function}

\item{z}{Argument of the hypergeometric function}

\item{b}{Second parameter of the hypergeometric function}

\item{a1}{First parameter of the hypergeometric function}

\item{a2}{Second parameter of the hypergeometric function}
}
\value{
A single numeric value with the computed hypergeometric function.
}
\description{
Functions to compute various hypergeometric functions.
}
\examples{
# Hypergeometric Function 1F0
hypergeometric_1F0(2, 0.2)
# Hypergeometric Function 0F1
hypergeometric_0F1(1, 0.8)
# Hypergeometric Function 2F0
hypergeometric_2F0(0.1, -1, 0.1)
# Hypergeometric Function 1F1
hypergeometric_1F1(2, 3, 1)
# Regularised Hypergeometric Function 1F1
hypergeometric_1F1_regularized(2, 3, 1)
# Logarithm of the Hypergeometric Function 1F1
log_hypergeometric_1F1(2, 3, 1)
# Hypergeometric Function pFq
hypergeometric_pFq(c(2, 3), c(4, 5), 6)
}
\seealso{
\href{https://www.boost.org/doc/libs/1_87_0/libs/math/doc/html/math_toolkit/hypergeometric.html}{Boost Documentation} for more details on the mathematical background.
}
