% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp_data.R
\name{birp_data_from_file}
\alias{birp_data_from_file}
\title{Creating a Birp Data Object based on filenames}
\usage{
birp_data_from_file(filenames, method_names = NA, sep = ",")
}
\arguments{
\item{filenames}{A vector of filenames specifying the input file(s) (one per method)}

\item{method_names}{Names to distinguish the methods. If NA, method names will be derived from filenames}

\item{sep}{The field separator character}
}
\value{
An object of type \link{birp_data}
}
\description{
This function creates a birp_data object
}
\examples{
dir <- system.file("extdata", package = "birp")
filenames <- file.path(dir, "birp_Method_1_simulated_counts.txt")
data <- birp_data_from_file(filenames = filenames, sep = "\t")
}
