\name{ETE}
\encoding{UTF-8}
\alias{ETE}
\title{
Calculation of the Ordinate For an Arbitrary Point on the Troscianko Curve in the Plane  
}
\description{
\code{ETE} is used to calculate the \emph{y}-value for an arbitrary point on the Troscianko curve 
that was generated by the explicit Troscianko equation.
}
\usage{
ETE(P, x)
}
\arguments{
  \item{P}{the parameters of the explicit Troscianko equation, including \eqn{a}, \eqn{\alpha_{0}}, \eqn{\alpha_{1}}, and \eqn{\alpha_{2}}.}
  \item{x}{the \emph{x}-value used in the explicit Troscianko equation.}
}
\details{
The explicit Troscianko equation is recommended as: 
\deqn{ y = a\,\exp\left\{\alpha_{0}+\alpha_{1}\,\left(\frac{x}{a}\right)+\alpha_{2}\, \left(\frac{x}{a}\right)^2\right\}\sqrt{1-\left(\frac{x}{a}\right)^2}, }
where \eqn{x} and \eqn{y} represent the abscissa and ordinate of an arbitrary point on the explicit Troscianko curve; 
\eqn{a}, \eqn{\alpha_{0}}, \eqn{\alpha_{1}}, and \eqn{\alpha_{2}} are parameters to be estimated.
}
\value{
The \eqn{y} values predicted by the explicit Troscianko equation.
}
\note{
We only considered the upper part of the egg-shape curve in the above expressions because 
the lower part is symmetrical to the upper part around the \emph{x}-axis.  
The mid-line of an egg's profile in \code{\link{ETE}} is aligned to 
the \emph{x}-axis. The argument, \code{P}, in the \code{\link{ETE}} function has the same parameters, 
\eqn{\alpha_{0}}, \eqn{\alpha_{1}}, and \eqn{\alpha_{2}}, as those in the \code{\link{TE}} function. 
However, the former has an additional parameter \eqn{a} than the latter, which represents half 
the egg's length. The \code{\link{lmTE}} function is based on the \code{\link{TE}} function, while 
the \code{\link{fitETE}} function is based on the \code{\link{ETE}} function here. 
In addition, the values in \code{x} > \eqn{a} (i.e., the first element in \code{P}) 
are forced to be \eqn{a}, and the values in \code{x} < \eqn{-a} will be forced to be \eqn{-a}.
}
\author{
Peijian Shi \email{pjshi@njfu.edu.cn}, Johan Gielis \email{johan.gielis@uantwerpen.be}, 
Brady K. Quinn \email{Brady.Quinn@dfo-mpo.gc.ca}.
}
\references{
Biggins, J.D., Montgomeries, R.M., Thompson, J.E., Birkhead, T.R. (2022) 
Preston’s universal formula for avian egg shape. \emph{Ornithology} 
139, ukac028. \doi{10.1093/ornithology/ukac028}

Biggins, J.D., Thompson, J.E., Birkhead, T.R. (2018) Accurately quantifying 
the shape of birds' eggs. \emph{Ecology and Evolution} 8, 9728\eqn{-}9738. \doi{10.1002/ece3.4412}

Lian, M., He, K., Ratkowsky, D.A., Chen, L., Wang, J., Wang, L., Yao, W., Shi, P. (2024) 
Comparison of egg-shape equations using relative curvature measures of nonlinearity. 
\emph{Poultry Science} 103, 104069. \doi{10.1016/j.psj.2024.104069}

Shi, P., Gielis, J., Quinn, B.K., Niklas, K.J., Ratkowsky, D.A., Schrader, J., Ruan, H., 
Wang, L., Niinemets, Ü. (2022) 'biogeom': An R package for simulating and fitting natural 
shapes. \emph{Annals of the New York Academy of Sciences} 1516, 123\eqn{-}134. \doi{10.1111/nyas.14862}

Shi, P., Wang, L., Quinn, B.K., Gielis, J. (2023) A new program to estimate the parameters 
of Preston's equation, a general formula for describing the egg shape of birds. \emph{Symmetry} 
15, 231. \doi{10.3390/sym15010231}

Troscianko, J. (2014). A simple tool for calculating egg shape, volume and surface area from digital images. 
\emph{Ibis}, 156, 874\eqn{-}878. \doi{10.1111/ibi.12177} 
}
\seealso{
\code{\link{curveETE}}, \code{\link{fitETE}}, \code{\link{SurfaceAreaETE}}, \code{\link{VolumeETE}}
}
\examples{
  Par5 <- c(2.25, -0.38, -0.29, -0.16)
  xx2  <- seq(-2.25, 2.25, len=2000)
  yy3  <- ETE(P=Par5, x=xx2)
  yy4  <- -ETE(P=Par5, x=xx2)

  dev.new()
  plot(xx2, yy3, asp=1, type="l", col=4, cex.lab=1.5, cex.axis=1.5,
       xlim=c(-3, 3), ylim=c(-3, 3), 
       xlab=expression(italic(x)), ylab=expression(italic(y)))
  lines(xx2, yy4, col=2)  

  graphics.off()
}