% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_optimize_para.R
\name{optimize_para}
\alias{optimize_para}
\title{Fit Parameters}
\usage{
optimize_para(
  data,
  id,
  obj_func,
  n_params,
  n_trials,
  lower,
  upper,
  initial_params = NA,
  initial_size = 50,
  iteration = 10,
  seed = 123,
  algorithm
)
}
\arguments{
\item{data}{[data.frame] raw data. 
This data should include the following mandatory columns: 
- "sub", "time_line", "L_choice", "R_choice", "L_reward", "R_reward".}

\item{id}{[integer] which subject is going to be analyzed.
is being analyzed. The value should correspond to an entry in the "sub" 
column, which must contain the subject IDs. 
e.g., `id = 18`}

\item{obj_func}{[function] a function with only ONE argument `params`. 
Additionally, it is important to note that the data needs to be retrieved 
from fit_env() and the results passed back to fit_env(). 
This function returns the log likelihood (logL).}

\item{n_params}{[integer] The number of free parameters in your model.}

\item{n_trials}{[integer] The total number of trials in your experiment.}

\item{lower}{[vector] lower bounds of free parameters}

\item{upper}{[vector] upper bounds of free parameters}

\item{initial_params}{[vector] Initial values for the free parameters. 
automatically generate initial values.
for `L-BFGS-B`, `GenSA`, set `initial = c(0, 0, ...)`}

\item{initial_size}{[integer] Initial population size for the free parameters. 
automatically generate initial values.
for `Bayesian`, `GA`, set `initial = 50`}

\item{iteration}{[integer] the number of iteration}

\item{seed}{[integer] random seed. This ensures that the results are 
reproducible and remain the same each time the function is run. 
default: `seed = 123`}

\item{algorithm}{[character] Choose a algorithm package from 
`L-BFGS-B`, `GenSA`, `GA`, `DEoptim`, `Bayesian`, `PSO`, `CMA-ES`}
}
\value{
the result of binaryRL with optimal parameters
}
\description{
This function is an internal function of `fit_p` We isolate it from direct use
 by capable users.

 The function provides four optimization algorithms: 

   1. L-BFGS-B (from `stats::optim`); 
   2. Simulated Annealing (`GenSA::GenSA`); 
   3. Genetic Algorithm (`GA::ga`); 
   4. Differential Evolution (`DEoptim::DEoptim`); 
   5. Bayesian Optimization (`mlrMBO::mbo`); 
   6. Particle Swarm Optimization (`pso::psoptim`); 
   7. Covariance Matrix Adapting Evolutionary Strategy (`cmaes::cma_es`); 

 For more information, please refer to the GitHub repository:
 https://github.com/yuki-961004/binaryRL
}
