% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funSource.R
\name{funSource}
\alias{funSource}
\title{Source code of a function}
\usage{
funSource(x, character.only = is.character(x), local = FALSE)
}
\arguments{
\item{x}{Function name, with or without quotation marks.
Trailing brackets are removed: \code{xx()} -> \code{"xx"}.\cr
Can be \code{package::function}, which must be quoted for
non-loaded packages.}

\item{character.only}{If TRUE, look for \code{SomeFun} instead of \code{MyFun}
in case \code{MyFun <- "SomeFun"}. 
DEFAULT: \code{\link{is.character}(x)}}

\item{local}{Open offline version of the code? Lacks comments and
original formatting of source code. DEFAULT: FALSE}
}
\value{
links that are also opened with \code{\link{browseURL}}
}
\description{
open source code of a function in a loaded or specified package on 
github.com/cran or github.com/wch/r-source
}
\examples{
\dontrun{ ## browser windows should not be opened in CRAN checks
funSource("head")
funSource(message()) # handles brackets if fun can be evaluated without input
funSource("require", local=TRUE) # usefull when offline

funSource("OSMscale::earthDist") # works even for non-installed CRAN packages

is.error(funSource("earthDist"), TRUE, TRUE) # Error for unloaded package
require(plotrix); require(scales)
funSource(rescale) # from the last loaded package

tail <- function(...) stop("This is a dummy function. Type: rm(tail)")
funSource("tail")
rm(tail)
}

}
\seealso{
\url{https://github.com/brry/rskey#rskey} to add this as a keyboard shortcut
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jan+Dec 2016, May 2017, April 2019
}
