% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdlim4.R
\name{bdlim4}
\alias{bdlim4}
\title{Fit the BDLIM model with all 4 patterns of modification}
\usage{
bdlim4(
  y,
  exposure,
  covars,
  group,
  id = NULL,
  df,
  nits,
  nburn = round(nits/2),
  nthin = 1,
  parallel = FALSE,
  family = "gaussian"
)
}
\arguments{
\item{y}{A vector of outcomes}

\item{exposure}{A matrix of exposures with one row for each individual}

\item{covars}{A matrix or data.frame of covariates This should not include the grouping factor (see group below). This may include factor variables.}

\item{group}{A vector of group memberships. This should be a factor variable.}

\item{id}{An optional vector of individual IDs if there are repeated measures or other groupings that a random intercept should be included for. This must be a factor variable.}

\item{df}{Degrees of freedom for the weight functions}

\item{nits}{Number of MCMC iterations.}

\item{nburn}{Number of MCMC iterations to be discarded as burn in. The default is half if the MCMC iterations. This is only used for WAIC in this function but is passed to summary and plot functions and used there.}

\item{nthin}{Thinning factors for the MCMC. This is only used for WAIC in this function but is passed to summary and plot functions and used there.}

\item{parallel}{Logical to use parallel computing for 4 models. If TRUE then the min of 4 and number of cores available will be used.}

\item{family}{Family of model to be used. Supported options are "gaussian" for a normal/Gaussian linear model and "binomial" for a logistic model.}
}
\value{
A list of results from each different pattern of modification and model compassion metrics
}
\description{
Fit the BDLIM model with all 4 patterns of modification
}
\examples{
\donttest{

# run BDLIM with modification by ChildSex
fit_sex <- bdlim4(
  y = sbd_bdlim$bwgaz,
  exposure = sbd_bdlim[,paste0("pm25_",1:37)],
  covars = sbd_bdlim[,c("MomPriorBMI","MomAge","race","Hispanic",
                                   "EstMonthConcept","EstYearConcept")],
  group = as.factor(sbd_bdlim$ChildSex),
  df = 5,
  nits = 5000,
  parallel = FALSE
)

# show model comparison results
fit_sex

#summarize results
sfit_sex <- summary(fit_sex)
sfit_sex
# graph the estimated distributed lag functions for each group
plot(sfit_sex)

}
}
