// Generated by rstantools.  Do not edit by hand.

/*
    path is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    path is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with path.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_regime_1_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 27> locations_array__ =
  {" (found before start of program)",
  " (in 'regime_1', line 9, column 2 to column 12)",
  " (in 'regime_1', line 10, column 2 to column 24)",
  " (in 'regime_1', line 13, column 2 to column 23)",
  " (in 'regime_1', line 26, column 2 to column 20)",
  " (in 'regime_1', line 17, column 18 to column 41)",
  " (in 'regime_1', line 17, column 4 to column 41)",
  " (in 'regime_1', line 16, column 9 to line 18, column 3)",
  " (in 'regime_1', line 15, column 18 to column 38)",
  " (in 'regime_1', line 15, column 4 to column 38)",
  " (in 'regime_1', line 14, column 21 to line 16, column 3)",
  " (in 'regime_1', line 14, column 2 to line 18, column 3)",
  " (in 'regime_1', line 29, column 4 to column 55)",
  " (in 'regime_1', line 28, column 17 to line 30, column 3)",
  " (in 'regime_1', line 28, column 2 to line 30, column 3)",
  " (in 'regime_1', line 21, column 2 to column 28)",
  " (in 'regime_1', line 22, column 2 to column 31)",
  " (in 'regime_1', line 23, column 2 to column 29)",
  " (in 'regime_1', line 2, column 2 to column 17)",
  " (in 'regime_1', line 3, column 2 to column 17)",
  " (in 'regime_1', line 4, column 8 to column 9)",
  " (in 'regime_1', line 4, column 2 to column 20)",
  " (in 'regime_1', line 5, column 2 to column 25)",
  " (in 'regime_1', line 6, column 8 to column 9)",
  " (in 'regime_1', line 6, column 2 to column 24)",
  " (in 'regime_1', line 13, column 8 to column 9)",
  " (in 'regime_1', line 26, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_regime_1 final : public model_base_crtp<model_regime_1> {
private:
  int T;
  int K;
  std::vector<double> x_t;
  int est_sigma;
  std::vector<double> sigma_t;
public:
  ~model_regime_1() {}
  model_regime_1(stan::io::var_context& context__, unsigned int
                 random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_regime_1_namespace::model_regime_1";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 18;
      context__.validate_dims("data initialization", "T", "int",
        std::vector<size_t>{});
      T = std::numeric_limits<int>::min();
      current_statement__ = 18;
      T = context__.vals_i("T")[(1 - 1)];
      current_statement__ = 18;
      stan::math::check_greater_or_equal(function__, "T", T, 1);
      current_statement__ = 19;
      context__.validate_dims("data initialization", "K", "int",
        std::vector<size_t>{});
      K = std::numeric_limits<int>::min();
      current_statement__ = 19;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 19;
      stan::math::check_greater_or_equal(function__, "K", K, 1);
      current_statement__ = 20;
      stan::math::validate_non_negative_index("x_t", "T", T);
      current_statement__ = 21;
      context__.validate_dims("data initialization", "x_t", "double",
        std::vector<size_t>{static_cast<size_t>(T)});
      x_t = std::vector<double>(T, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 21;
      x_t = context__.vals_r("x_t");
      current_statement__ = 22;
      context__.validate_dims("data initialization", "est_sigma", "int",
        std::vector<size_t>{});
      est_sigma = std::numeric_limits<int>::min();
      current_statement__ = 22;
      est_sigma = context__.vals_i("est_sigma")[(1 - 1)];
      current_statement__ = 22;
      stan::math::check_greater_or_equal(function__, "est_sigma", est_sigma,
        0);
      current_statement__ = 23;
      stan::math::validate_non_negative_index("sigma_t", "T", T);
      current_statement__ = 24;
      context__.validate_dims("data initialization", "sigma_t", "double",
        std::vector<size_t>{static_cast<size_t>(T)});
      sigma_t = std::vector<double>(T,
                  std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 24;
      sigma_t = context__.vals_r("sigma_t");
      current_statement__ = 25;
      stan::math::validate_non_negative_index("sigmas", "T", T);
      current_statement__ = 26;
      stan::math::validate_non_negative_index("log_lik", "T", T);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = 1 + 1;
  }
  inline std::string model_name() const final {
    return "model_regime_1";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_regime_1_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      local_scalar_t__ mu_k = DUMMY_VAR__;
      current_statement__ = 1;
      mu_k = in__.template read<local_scalar_t__>();
      local_scalar_t__ sigma_k = DUMMY_VAR__;
      current_statement__ = 2;
      sigma_k = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      std::vector<local_scalar_t__> sigmas =
        std::vector<local_scalar_t__>(T, DUMMY_VAR__);
      current_statement__ = 11;
      if (stan::math::logical_eq(est_sigma, 1)) {
        current_statement__ = 9;
        for (int i = 1; i <= T; ++i) {
          current_statement__ = 8;
          stan::model::assign(sigmas, sigma_k, "assigning variable sigmas",
            stan::model::index_uni(i));
        }
      } else {
        current_statement__ = 6;
        for (int i = 1; i <= T; ++i) {
          current_statement__ = 5;
          stan::model::assign(sigmas,
            stan::model::rvalue(sigma_t, "sigma_t", stan::model::index_uni(i)),
            "assigning variable sigmas", stan::model::index_uni(i));
        }
      }
      {
        current_statement__ = 15;
        lp_accum__.add(stan::math::student_t_lpdf<propto__>(mu_k, 3, 0, 3));
        current_statement__ = 16;
        lp_accum__.add(stan::math::student_t_lpdf<propto__>(sigma_k, 3, 0, 1));
        current_statement__ = 17;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(x_t, mu_k, sigmas));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_regime_1_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      double mu_k = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 1;
      mu_k = in__.template read<local_scalar_t__>();
      double sigma_k = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      sigma_k = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      std::vector<double> sigmas =
        std::vector<double>(T, std::numeric_limits<double>::quiet_NaN());
      out__.write(mu_k);
      out__.write(sigma_k);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 11;
      if (stan::math::logical_eq(est_sigma, 1)) {
        current_statement__ = 9;
        for (int i = 1; i <= T; ++i) {
          current_statement__ = 8;
          stan::model::assign(sigmas, sigma_k, "assigning variable sigmas",
            stan::model::index_uni(i));
        }
      } else {
        current_statement__ = 6;
        for (int i = 1; i <= T; ++i) {
          current_statement__ = 5;
          stan::model::assign(sigmas,
            stan::model::rvalue(sigma_t, "sigma_t", stan::model::index_uni(i)),
            "assigning variable sigmas", stan::model::index_uni(i));
        }
      }
      if (emit_transformed_parameters__) {
        out__.write(sigmas);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> log_lik =
        Eigen::Matrix<double,-1,1>::Constant(T,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 14;
      for (int n = 1; n <= T; ++n) {
        current_statement__ = 12;
        stan::model::assign(log_lik,
          stan::math::normal_lpdf<false>(
            stan::model::rvalue(x_t, "x_t", stan::model::index_uni(n)), mu_k,
            stan::model::rvalue(sigmas, "sigmas", stan::model::index_uni(n))),
          "assigning variable log_lik", stan::model::index_uni(n));
      }
      out__.write(log_lik);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ mu_k = DUMMY_VAR__;
      current_statement__ = 1;
      mu_k = in__.read<local_scalar_t__>();
      out__.write(mu_k);
      local_scalar_t__ sigma_k = DUMMY_VAR__;
      current_statement__ = 2;
      sigma_k = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sigma_k);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "mu_k", "double",
        std::vector<size_t>{});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "sigma_k",
        "double", std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ mu_k = DUMMY_VAR__;
      current_statement__ = 1;
      mu_k = context__.vals_r("mu_k")[(1 - 1)];
      out__.write(mu_k);
      local_scalar_t__ sigma_k = DUMMY_VAR__;
      current_statement__ = 2;
      sigma_k = context__.vals_r("sigma_k")[(1 - 1)];
      out__.write_free_lb(0, sigma_k);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"mu_k", "sigma_k"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"sigmas"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"log_lik"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{},
                std::vector<size_t>{}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(T)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(T)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "mu_k");
    param_names__.emplace_back(std::string() + "sigma_k");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        param_names__.emplace_back(std::string() + "sigmas" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "mu_k");
    param_names__.emplace_back(std::string() + "sigma_k");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        param_names__.emplace_back(std::string() + "sigmas" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"mu_k\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_k\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigmas\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(T) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(T) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"mu_k\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_k\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigmas\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(T) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(T) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (1 + 1);
    const size_t num_transformed = emit_transformed_parameters * (T);
    const size_t num_gen_quantities = emit_generated_quantities * (T);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (1 + 1);
    const size_t num_transformed = emit_transformed_parameters * (T);
    const size_t num_gen_quantities = emit_generated_quantities * (T);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_regime_1_namespace::model_regime_1;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_regime_1_namespace::profiles__;
}
#endif
#endif
