% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPost.R
\name{plotPost}
\alias{plotPost}
\title{Graphic display of a posterior probability distribution}
\usage{
plotPost(paramSampleVec, credMass = 0.95, compVal = NULL, ROPE = NULL,
  HDItextPlace = 0.7, showMode = FALSE, showCurve = FALSE, ...)
}
\arguments{
\item{paramSampleVec}{A vector of samples drawn from the target distribution.}

\item{credMass}{the probability mass to include in credible intervals, or
NULL to suppress plotting of credible intervals.}

\item{compVal}{a value for comparison with those plotted.}

\item{ROPE}{a two element vector, such as \code{c(-1, 1)}, specifying the
limits of the Region Of Practical Equivalence.}

\item{HDItextPlace}{a value in [0,1] that controls the horizontal position of
the labels at the ends of the HDI bar.}

\item{showMode}{logical: if TRUE, the mode is displayed instead of the mean.}

\item{showCurve}{logical: if TRUE, the posterior density will be represented
by a kernel density function instead of a histogram.}

\item{\dots}{graphical parameters and the \code{breaks} parameter for the
histogram.}
}
\value{
Returns an object of class \code{histogram} invisibly. Used for its
  plotting side-effect.
}
\description{
Plot the posterior probability distribution for a single parameter from a
vector of samples, typically from an MCMC process, with appropriate summary
statistics.
}
\details{
The data are plotted either as a histogram (above) or, if \code{showCurve =
TRUE}, as a fitted kernel density curve (below). Either the mean or the mode
of the distribution is displayed, depending on the parameter \code{showMode.}
The Highest Density Interval (HDI) is shown as a horizontal bar, with labels
for the ends of the interval.

\if{html}{\figure{plotPost1.jpg} }
\if{latex}{\figure{plotPost1.jpg}{options: width=5cm}}
\cr
\cr
\if{html}{\figure{plotPost2.jpg} }
\if{latex}{\figure{plotPost2.jpg}{options: width=5cm}}

If values for a ROPE are supplied, these are shown as dark red vertical
dashed lines, together with the percentage of probability mass within the
ROPE. If a comparison value (\code{compVal}) is supplied, this is shown as a
vertical green dotted line, together with the probability mass below and
above this value.
}
\note{
The origin of this function is
  \href{https://cran.r-project.org/package=BEST}{the BEST
  package} which is based on Kruschke(2015, 2013).
}
\examples{
# Generate some data
tst <- rnorm(1e5, 3, 1)
plotPost(tst)
plotPost(tst, col='wheat', border='magenta')
plotPost(tst, credMass=0.8, ROPE=c(-1,1), xlab="Response variable")
plotPost(tst, showMode=TRUE, showCurve=TRUE, compVal=5.5)

# For integers:
tst <- rpois(1e5, 12)
plotPost(tst)

# A severely bimodal distribution:
tst2 <- c(rnorm(1e5), rnorm(5e4, 7))
plotPost(tst2)                  # A valid 95\% CrI, but not HDI
plotPost(tst2, showCurve=TRUE)  # Correct 95\% HDI
}
\references{
Kruschke, J. K. (2015) \emph{Doing Bayesian data analysis, second
  edition: A tutorial with R, JAGS, and Stan.} Waltham, MA: Academic Press /
  Elsevier.

Kruschke, J. K. (2013) Bayesian estimation supersedes the t test.
  \emph{Journal of Experimental Psychology: General}, \bold{142(2)}, 573.
}
\seealso{
For details of the HDI calculation, see \code{\link{hdi}}.
}
\author{
John Kruschke, modified by Mike Meredith
}
