% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permVimp.R
\name{permVimp}
\alias{permVimp}
\title{permVimp}
\usage{
permVimp(model, data, response, numTreesPerm = NULL, plotType = "barplot")
}
\arguments{
\item{model}{Model created from either the BART, dbarts or bartMachine packages.}

\item{data}{A data frame containing variables in the model.}

\item{response}{The name of the response for the fit.}

\item{numTreesPerm}{The number of trees to be used in the null model.
As suggested by Chipman (2009), a small number of trees is recommended (~20) to force important
variables to used in the model. If NULL, then the number of trees from the true model is used.}

\item{plotType}{Either a bar plot ('barplot') or a point plot ('point')}
}
\value{
A variable selection plot.
}
\description{
A variable selection approach which creates a null model by
permuting the response, rebuilding the model, and calculating the inclusion proportion (IP) on the null model.
The final result displayed is the original model's IP minus the null IP.
}
\examples{
if (requireNamespace("dbarts", quietly = TRUE)) {
 # Load the dbarts package to access the bart function
 library(dbarts)
 # Get Data
 df <- na.omit(airquality)
 # Create Simple dbarts Model For Regression:
 set.seed(1701)
 dbartModel <- bart(df[2:6],
   df[, 1],
   ntree = 5,
   keeptrees = TRUE,
   nskip = 10,
   ndpost = 10
 )
 # Tree Data
 trees_data <- extractTreeData(model = dbartModel, data = df)
 permVimp(model = dbartModel, data = df, response = 'Ozone', numTreesPerm = 2, plotType = 'point')
}

}
