% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_prior-constructors.R
\name{Lin_AR}
\alias{Lin_AR}
\title{Linear Prior with Autoregressive Errors}
\usage{
Lin_AR(n_coef = 2, s = 1, sd = 1, along = NULL)
}
\arguments{
\item{n_coef}{Number of lagged terms in the
model, ie the order of the model. Default is \code{2}.}

\item{s}{Scale for the innovations in the
AR process. Default is \code{1}.}

\item{sd}{Standard deviation in the prior for
the slope of the line. Larger values imply
steeper slopes. Default is 1.}

\item{along}{Name of the variable to be used
as the "along" variable. Only used with
interactions.}
}
\value{
An object of class \code{"bage_prior_linar"}.
}
\description{
Use a line or lines with autoregressive
errors to model a main effect
or interaction. Typically used with time.
}
\details{
If \code{Lin_AR()} is used with an interaction,
separate lines are constructed along
the "along" variable, within each combination
of the "by" variables.

The order of the autoregressive errors is
controlled by the \code{n_coef} argument. The
default is 2.

Argument \code{s} controls the size of the innovations.
Smaller values tend to give smoother estimates.

Argument \code{sd} controls the size of the slopes of
the lines. Larger values can give more steeply
sloped lines.
}
\section{Mathematical details}{


When \code{Lin_AR()} is used with a main effect,

\deqn{\beta_1 = \alpha + \epsilon_1}
\deqn{\beta_j = \alpha + (j - 1) \eta + \epsilon_j, \quad j > 1}
\deqn{\alpha \sim \text{N}(0, 1)}
\deqn{\epsilon_j = \phi_1 \epsilon_{j-1} + \cdots + \phi_n \epsilon_{j-n} + \varepsilon_j}
\deqn{\varepsilon_j \sim \text{N}(0, \omega^2),}

and when it is used with an interaction,

\deqn{\beta_{u,1} = \alpha_u + \epsilon_{u,1}}
\deqn{\beta_{u,v} = \eta (v - 1) + \epsilon_{u,v}, \quad v = 2, \cdots, V}
\deqn{\alpha_u \sim \text{N}(0, 1)}
\deqn{\epsilon_{u,v} = \phi_1 \epsilon_{u,v-1} + \cdots + \phi_n \epsilon_{u,v-n} + \varepsilon_{u,v},}
\deqn{\varepsilon_{u,v} \sim \text{N}(0, \omega^2).}

where
\itemize{
\item \eqn{\pmb{\beta}} is the main effect or interaction;
\item \eqn{j} denotes position within the main effect;
\item \eqn{u} denotes position within the "along" variable of the interaction;
\item \eqn{u} denotes position within the "by" variable(s) of the interaction; and
\item \eqn{n} is \code{n_coef}.
}

The slopes have priors
\deqn{\eta \sim \text{N}(0, \text{sd}^2)}
and
\deqn{\eta_u \sim \text{N}(0, \text{sd}^2).}

Internally, \code{Lin_AR()} derives a value for \eqn{\omega} that
gives \eqn{\epsilon_j} or \eqn{\epsilon_{u,v}} a marginal
variance of \eqn{\tau^2}. Parameter \eqn{\tau}
has a half-normal prior
\deqn{\tau \sim \text{N}^+(0, \text{s}^2),}
where a value for \code{s} is provided by the user.

The \eqn{\phi_1, \cdots, \phi_k} are restricted to values
between -1 and 1 that jointly lead to a stationary model. The quantity
\eqn{r = \sqrt{\phi_1^2 + \cdots + \phi_k^2}} has
boundary-avoiding prior

\deqn{r \sim \text{Beta}(2, 2).}
}

\examples{
Lin_AR()
Lin_AR(n_coef = 3, s = 0.5, sd = 2)
}
\seealso{
\itemize{
\item \code{\link[=Lin_AR1]{Lin_AR1()}} Special case of \code{Lin_AR()}
\item \code{\link[=Lin]{Lin()}} Line with independent normal errors
\item \code{\link[=AR]{AR()}} AR process with no line
\item \link{priors} Overview of priors implemented in \strong{bage}
\item \code{\link[=set_prior]{set_prior()}} Specify prior for intercept,
main effect, or interaction
}
}
