#' Hass Avocado US Sales
#'
#' @description Weekly summary of Hass avocado sales for the United States
#'
#' @details This dataset contains a weekly sales summary for Hass avocados for the US.
#'
#' @format a dataframe with 15 variables.
#' \describe{
#'   \item{week_ending}{The date of the last day of the week in YYYY-MM-DD format.}
#'   \item{avg_price_nonorg}{The average selling price in US$ for non-organic Hass avocados. Not adjusted for inflation.}
#'   \item{plu4046}{The amount of PLU 4046 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{plu4225}{The amount of PLU 4225 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{plu4770}{The amount of PLU 4770 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{small_nonorg_bag}{The amount of non-organic Hass avocados (they can be a mix of PLUs) sold in small pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#'   \item{large_nonorg_bag}{The amount of non-organic Hass avocados (they can be a mix of PLUs) sold in large pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#'   \item{xlarge_nonorg_bag}{The amount of non-organic Hass avocados (they can be a mix of PLUs) sold in extra-large pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#'   \item{avg_price_org}{The average selling price in US$ for organic Hass avocados. Not adjusted for inflation.}
#'   \item{plu94046}{The amount of PLU 94046 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{plu94225}{The amount of PLU 94225 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{plu94770}{The amount of PLU 94770 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{small_org_bag}{The amount of organic Hass avocados (they can be a mix of PLUs) sold in small pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#'   \item{large_org_bag}{The amount of organic Hass avocados (they can be a mix of PLUs) sold in large pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#'   \item{xlarge_org_bag}{The amount of organic Hass avocados (they can be a mix of PLUs) sold in extra-large pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#' }
#'
#' @source Hass Avocado Board \href{https://hassavocadoboard.com}{Category Data}
#' @keywords avocados timeseries revenue datasets
#'
"hass_usa"

#' Hass Avocado Regional Sales
#'
#' @description Weekly summary of Hass avocado sales for the regions within the United States
#'
#' @details This dataset contains a weekly sales summary for Hass avocados for regions (as defined by the Hass Avocado Board) within the US.
#'
#' @format a dataframe with 16 variables.
#'
#' \describe{
#'   \item{week_ending}{The date of the last day of the week in YYYY-MM-DD format.}
#'   \item{region}{Specific region within the US as defined by the Hass Avocado Board.}
#'   \item{avg_price_nonorg}{The average selling price in US$ for non-organic Hass avocados. Not adjusted for inflation.}
#'   \item{plu4046}{The amount of PLU 4046 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{plu4225}{The amount of PLU 4225 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{plu4770}{The amount of PLU 4770 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{small_nonorg_bag}{The amount of non-organic Hass avocados (they can be a mix of PLUs) sold in small pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#'   \item{large_nonorg_bag}{The amount of non-organic Hass avocados (they can be a mix of PLUs) sold in large pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#'   \item{xlarge_nonorg_bag}{The amount of non-organic Hass avocados (they can be a mix of PLUs) sold in extra-large pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#'   \item{avg_price_org}{The average selling price in US$ for organic Hass avocados. Not adjusted for inflation.}
#'   \item{plu94046}{The amount of PLU 94046 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{plu94225}{The amount of PLU 94225 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{plu94770}{The amount of PLU 94770 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{small_org_bag}{The amount of organic Hass avocados (they can be a mix of PLUs) sold in small pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#'   \item{large_org_bag}{The amount of organic Hass avocados (they can be a mix of PLUs) sold in large pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#'   \item{xlarge_org_bag}{The amount of organic Hass avocados (they can be a mix of PLUs) sold in extra-large pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#' }
#'
"hass_region"

#' Hass Avocado Sales
#'
#' @description Weekly summary of Hass avocado sales for specific locations found within regions of the United States
#'
#' @details This dataset contains a weekly sales summary for Hass avocados for locations within regions (as defined by the Hass Avocado Board) the US.
#'
#' @format a dataframe with 17 variables
#'
#' \describe{
#'   \item{week_ending}{The date of the last day of the week in YYYY-MM-DD format.}
#'   \item{location}{Specific location within a region of the US. These locations enable a further deep-dive into avocado sales within a region.}
#'   \item{region}{Specific region within the US as defined by the Hass Avocado Board.}
#'   \item{avg_price_nonorg}{The average selling price in US$ for non-organic Hass avocados. Not adjusted for inflation.}
#'   \item{plu4046}{The amount of PLU 4046 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{plu4225}{The amount of PLU 4225 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{plu4770}{The amount of PLU 4770 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{small_nonorg_bag}{The amount of non-organic Hass avocados (they can be a mix of PLUs) sold in small pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#'   \item{large_nonorg_bag}{The amount of non-organic Hass avocados (they can be a mix of PLUs) sold in large pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#'   \item{xlarge_nonorg_bag}{The amount of non-organic Hass avocados (they can be a mix of PLUs) sold in extra-large pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#'   \item{avg_price_org}{The average selling price in US$ for organic Hass avocados. Not adjusted for inflation.}
#'   \item{plu94046}{The amount of PLU 94046 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{plu94225}{The amount of PLU 94225 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{plu94770}{The amount of PLU 94770 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
#'   \item{small_org_bag}{The amount of organic Hass avocados (they can be a mix of PLUs) sold in small pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#'   \item{large_org_bag}{The amount of organic Hass avocados (they can be a mix of PLUs) sold in large pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#'   \item{xlarge_org_bag}{The amount of organic Hass avocados (they can be a mix of PLUs) sold in extra-large pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
#' }
#'
"hass"
