# WARNING - Generated by {fusen} from dev/flat_create_dependencies_file.Rmd: do not edit by hand

#' dependencies_file_text
#' 
#' Create the text of create_dependencies_file()
#' 
#' @param ll a vector of all packages
#' @param remotes_orig a vector of remotes 
#' @param install_only_if_missing Logical Modify the installation instructions to check, beforehand, if the packages are missing . (default FALSE)
#' @importFrom glue glue
#' @return a list
#' 
#' @noRd
dependencies_file_text <- function(ll, remotes_orig, install_only_if_missing = FALSE){
    
  if (length(remotes_orig) != 0) {

    remotes_orig_pkg <- gsub("^.*/|^local::|.git$", "", remotes_orig)
    remotes_without_orig <- gsub("^.*::/{0,1}", "", remotes_orig)
    # Remove remotes from ll
    ll <- ll[!ll %in% remotes_orig_pkg]
    # Install script
    inst_remotes <- remotes_orig
    # _If no (), then bioc
    w.bioc <- grepl("bioc::", remotes_orig)
    inst_remotes[w.bioc] <- glue("remotes::install_bioc('{remotes_without_orig[w.bioc]}')")
    # _If no (), then local
    w.local <- grepl("local::", remotes_orig)
    inst_remotes[w.local] <- glue("remotes::install_local('{remotes_without_orig[w.local]}')")
    # _If no (), then git
    w.git <- grepl("git::", remotes_orig)
    inst_remotes[w.git] <- glue("remotes::install_git('{remotes_without_orig[w.git]}')")
    # _If no (), then git
    w.gitlab <- grepl("gitlab::", remotes_orig)
    inst_remotes[w.gitlab] <- glue("remotes::install_gitlab('{remotes_without_orig[w.gitlab]}')")
    # _If no (), then github
    w.github <- !grepl("\\(", remotes_orig) & !grepl("remotes::", inst_remotes)
    inst_remotes[w.github] <- glue("remotes::install_github('{remotes_without_orig[w.github]}')")

    
    # Install only if missing
    if (isTRUE(install_only_if_missing)) {
      inst_remotes <-
        paste0(
          "if(isFALSE(requireNamespace('",
          remotes_orig_pkg,
          "', quietly = TRUE))) {","message('installation of " ,remotes_orig_pkg,"');", inst_remotes,
          "}"
        )
      
      install_pkg_remote <-
        "if(isFALSE(requireNamespace('remotes', quietly = TRUE))) {install.packages(\"remotes\")}"
    } else {
       install_pkg_remote <- "install.packages(\"remotes\")"
      }
    
    # _Others (WIP...)
    inst_remotes[!(w.github | w.local | w.bioc | w.git | w.gitlab)] <- remotes_orig[!(w.github | w.local | w.bioc | w.git | w.gitlab)]

    # Store content
    remotes_content <- paste("# Remotes ----",
                             install_pkg_remote,
                             paste(inst_remotes, collapse = "\n"),
                             sep = "\n")
  } else {
    remotes_content <- "# No Remotes ----"
  }

  

  if (length(ll) != 0) {

    attachment_content <- glue::glue(
      '
# Attachments ----
to_install <- c("*{glue::glue_collapse(as.character(ll), sep="\\", \\"")}*")
  for (i in to_install) {
    message(paste("looking for ", i))
    if (!requireNamespace(i, quietly = TRUE)) {
      message(paste("     installing", i))
      install.packages(i)
    }
  }\n\n', .open = "*{", .close = "}*")
  } else {
    attachment_content <- glue::glue(
      '
# No attachments ----
      \n\n', .open = "*{", .close = "}*")
  }
    content <- list("remotes_content" = remotes_content,
                    "attachment_content" = attachment_content)
  return(content)
}
