% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed.r
\name{get_feeds_created_by}
\alias{get_feeds_created_by}
\title{A view of the feed created by an actor.}
\usage{
get_feeds_created_by(
  actor,
  limit = 25L,
  cursor = NULL,
  parse = TRUE,
  verbose = NULL,
  .token = NULL
)
}
\arguments{
\item{actor}{user handle to retrieve feed from}

\item{limit}{Maximum number of records to return. For queries with more than
100 results, pagination is used automatically (one request per 100
results). The function stops when the limit is reached, but you will
usually get a few items more than requested.}

\item{cursor}{Cursor for pagination (to pick up an old search).}

\item{parse}{Parse the results or return the original nested object sent by
the server.}

\item{verbose}{Whether to print status messages to the Console
(\code{TRUE}/\code{FALSE}). Package default (when \code{NULL}) is to have
status messages. Can be changed with \code{Sys.setenv(ATR_VERBOSE =
  FALSE)}.}

\item{.token}{If you manage your own tokens, you can supply it here. Usually
\code{NULL} is OK and will automatically load or guide you to generate a
token.}
}
\value{
a data frame (or nested list) of feeds
}
\description{
A view of the feed created by an actor.
}
\examples{
\dontrun{
feed <- get_feeds_created_by("andrew.heiss.phd")
}
}
