% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed.r
\name{get_own_timeline}
\alias{get_own_timeline}
\title{Get your own timeline}
\usage{
get_own_timeline(
  algorithm = NULL,
  limit = 25L,
  cursor = NULL,
  parse = TRUE,
  verbose = NULL,
  .token = NULL
)
}
\arguments{
\item{algorithm}{algorithm used to sort the posts}

\item{limit}{Maximum number of records to return. For queries with more than
100 results, pagination is used automatically (one request per 100
results). The function stops when the limit is reached, but you will
usually get a few items more than requested.}

\item{cursor}{Cursor for pagination (to pick up an old search).}

\item{parse}{Parse the results or return the original nested object sent by
the server.}

\item{verbose}{Whether to print status messages to the Console
(\code{TRUE}/\code{FALSE}). Package default (when \code{NULL}) is to have
status messages. Can be changed with \code{Sys.setenv(ATR_VERBOSE =
  FALSE)}.}

\item{.token}{If you manage your own tokens, you can supply it here. Usually
\code{NULL} is OK and will automatically load or guide you to generate a
token.}
}
\value{
a data frame (or nested list) of posts
}
\description{
Get the posts that would be shown when you open the Bluesky app or website.
}
\examples{
\dontrun{
get_own_timeline()
get_own_timeline(algorithm = "reverse-chronological")
}
}
