% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametric_bootstrap.R
\name{parametric_bootstrap}
\alias{parametric_bootstrap}
\title{Perform Parametric Bootstrap Simulations}
\usage{
parametric_bootstrap(
  model,
  statistic,
  nsim,
  responses = NULL,
  refit_fn = NULL,
  show_progress = TRUE,
  simplify = TRUE,
  stat_hc = NULL,
  show_message_count = TRUE,
  show_warning_count = TRUE,
  show_not_converged_count = TRUE,
  ...
)
}
\arguments{
\item{model}{A fitted model object that will be used to simulate responses.}

\item{statistic}{A function that computes the desired statistic from the refitted model.
It must take the refitted model as an argument.}

\item{nsim}{The number of simulations to perform.}

\item{responses}{An optional list of values to be used as response variables to refit the model.}

\item{refit_fn}{Function to refit the model with new responses. If \code{NULL},
defaults to \code{get_refit(model, y, ...)}.}

\item{show_progress}{Display a progress bar for the simulation iteration.}

\item{simplify}{logical or character string; should the result be simplified to a vector,
matrix or higher dimensional array if possible? If occurs any errors during
the refit procedure, the results will be a list, regardless of the value of this argument.}

\item{stat_hc}{A function that verifies if the computed statistic is correct.
It should return nothing, just throw errors to halt execution.}

\item{show_message_count}{Show total of captured messages from \code{refit_fn} as a message.
It only shows if the number of messages is greater than 0.}

\item{show_warning_count}{Show total of captured warnings from \code{refit_fn} as a warning.
It only shows if the number of warnings is greater than 0.}

\item{show_not_converged_count}{Show total of models that didn't converge as a warning.
It only shows if the number of models that didn't converged is greater than 0.}

\item{...}{Additional arguments to be passed to \code{refit_fn}.}
}
\value{
A list containing the following elements:
\describe{
\item{\code{result}}{A list of length nsim if \code{simplify} is \code{FALSE}.
Otherwise an atomic vector or matrix or list of length nsim.
}
\item{\code{responses}}{The list of simulated response values.}
\item{\code{simulation_warning}}{A logical vector indicating whether a
warning occurred during model refitting for each simulation.}
\item{\code{converged}}{A logical vector indicating whether the model refit converged for each simulation.}
}
}
\description{
This function performs parametric bootstrap simulations by generating new response values based on the fitted model,
refitting the model on these new responses, and computing a user-defined statistic for each simulated model.
}
\details{
This function implements a parametric bootstrap procedure.
It generates new response values from the fitted model, refits
the model for each simulated response, and computes a user-defined statistic on the refitted model.
The refit function can be customized through the \code{refit_fn} argument.

If \code{show_progress} is \code{TRUE}, the progress of the simulations will be
displayed using a progress bar from the \code{cli} package.
}
\examples{

model <- lm(mpg ~ wt + hp, data = mtcars)
statistic <- function(model) coef(model)[["wt"]]
bootstrap_results <- parametric_bootstrap(model, statistic, nsim = 100)
wt_coefs <- Reduce(c, bootstrap_results$result)
summary(wt_coefs)

}
