% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_names.R
\name{assert_names_include}
\alias{assert_names_include}
\title{Assert that the input object includes a specified name}
\usage{
assert_names_include(
  x,
  names,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{An object to check for the presence of specific names}

\item{names}{A character vector of names to check for in \code{x}}

\item{msg}{A character string containing the error message to display if any of the \code{names} are not present in \code{x}}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if all \code{names} are present in \code{x}, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert that the input object includes a specified name
}
\examples{
try({
x <- list(a = 1, b = 2, c = 3)

assert_includes_name(x, "a") # Passes
assert_includes_name(x, c("a", "b")) # Passes
assert_includes_name(x, c("a", "b", "d")) # Throws default error message

assert_includes_name(x, c("a", "b", "d"), "Custom error message") # Throws custom error message
})

}
