% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_compare.R
\name{assert_equal}
\alias{assert_equal}
\title{Assert that the input objects are equal}
\usage{
assert_equal(
  x,
  y,
  tolerance = sqrt(.Machine$double.eps),
  check_names = TRUE,
  check_environment = TRUE,
  check_tzone = TRUE,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{An object to check}

\item{y}{The value to compare against}

\item{tolerance}{Differences smaller than tolerance are not reported. The default value is close to 1.5e-8 (numeric >= 0).}

\item{check_names}{should the names(.) of target and current should be compare (flag)}

\item{check_environment}{should the environments of functions should be compared?
You may need to set check.environment=FALSE in unexpected cases, such as when comparing two nls() fits. (flag)}

\item{check_tzone}{should  "tzone" attributes be compared. Important for comparing POSIXt objects. (flag)}

\item{msg}{A character string containing the error message to display if \code{x} is not equal to \code{y}}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is equal to the specified value, otherwise aborts with the error message specified by \code{msg}
}
\description{
Is \code{x} equal to \code{y}. powered by the \code{\link[=all.equal]{all.equal()}} function.
}
\examples{
try({
assert_equal(3, 3) # Passes
assert_equal(c(3, 3, 3), 3, ) # Fails
assert_equal(2, 3) # Throws error
})
}
