% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc_geo_multi.R
\name{arc_geo_multi}
\alias{arc_geo_multi}
\title{Geocoding using the ArcGIS REST API with multi-field query}
\usage{
arc_geo_multi(
  address = NULL,
  address2 = NULL,
  address3 = NULL,
  neighborhood = NULL,
  city = NULL,
  subregion = NULL,
  region = NULL,
  postal = NULL,
  postalext = NULL,
  countrycode = NULL,
  lat = "lat",
  long = "lon",
  limit = 1,
  full_results = FALSE,
  return_addresses = TRUE,
  verbose = FALSE,
  progressbar = TRUE,
  outsr = NULL,
  langcode = NULL,
  category = NULL,
  custom_query = list()
)
}
\arguments{
\item{address, address2, address3, neighborhood, city, subregion}{Address
components  (See \strong{Details}).}

\item{region, postal, postalext, countrycode}{More address components, see
(See \strong{Details}).}

\item{lat}{latitude column name in the output data (default  \code{"lat"}).}

\item{long}{longitude column name in the output data (default  \code{"lon"}).}

\item{limit}{maximum number of results to return per input address. Note
that each query returns a maximum of 50 results.}

\item{full_results}{returns all available data from the API service. This
is a shorthand of \verb{outFields=*}. See \strong{References}. If \code{FALSE} (default)
only the default values of the API would be returned. See also
\code{return_addresses} argument.}

\item{return_addresses}{return input addresses with results if \code{TRUE}.}

\item{verbose}{if \code{TRUE} then detailed logs are output to the console.}

\item{progressbar}{Logical. If \code{TRUE} displays a progress bar to indicate
the progress of the function.}

\item{outsr}{The spatial reference of the \verb{x,y} coordinates returned by a
geocode request. By default is \code{NULL} (i.e. the parameter won't be used in
the query). See \strong{Details} and \link{arc_spatial_references}.}

\item{langcode}{Sets the language in which reverse-geocoded addresses are
returned.}

\item{category}{A place or address type that can be used to filter results.
Several values can be used as well as a vector (i.e.
\code{c("Cinema", "Museum")}). See \link{arc_categories} for details.}

\item{custom_query}{API-specific parameters to be used, passed as a named
list.}
}
\value{
A \code{\link[tibble:tibble]{tibble}} object with the results. See the details of the output in  \href{https://developers.arcgis.com/rest/geocode/api-reference/geocoding-service-output.htm}{ArcGIS REST API Service output}.

The resulting output would include also the input parameters (columns with
prefix \code{q_}) for better tracking the results.
}
\description{
Geocodes addresses given specific address components.This function returns
the \code{\link[tibble:tibble]{tibble}} associated with the query.

For geocoding using a single text string use \code{\link[=arc_geo]{arc_geo()}} function.
}
\details{
More info and valid values in the \href{https://developers.arcgis.com/rest/geocode/api-reference/geocoding-find-address-candidates.htm}{ArcGIS REST docs}.
}
\section{Address components}{
This function allows to perform structured queries by different components of
an address. At least one field should be different than \code{NA} or \code{NULL}.

A vector of values can be provided for each parameter for multiple geocoding.
When using vectors on different parameters, their lengths should be the
same.

The following list provides a brief description of each parameter:
\itemize{
\item \code{address}: A string that represents the first line of a street address. In
most cases it will be the \strong{street name and house number} input, but it
can also be used to input building name or place-name.
\item \code{address2}: A string that represents the second line of a street address.
This can include \strong{street name/house number, building name, place-name, or
sub unit}.
\item \code{address3}: A string that represents the third line of a street address.
This can include \strong{street name/house number, building name, place-name, or
sub unit}.
\item \code{neighborhood}: The smallest administrative division associated with an
address, typically, a \strong{neighborhood} or a section of a larger populated
place.
\item \code{city}: The next largest administrative division associated with an
address, typically, a \strong{city or municipality}.
\item \code{subregion}: The next largest administrative division associated with an
address. Depending on the country, a sub region can represent a
\strong{county, state, or province}.
\item \code{region}: The largest administrative division associated with an address,
typically, a \strong{state or province}.
\item \code{postal}: The \strong{standard postal code} for an address, typically, a
three– to six-digit alphanumeric code.
\item \code{postalext}: A \strong{postal code extension}, such as the United States Postal
Service ZIP+4 code.
\item \code{countrycode}: A value representing the \strong{country}. Providing this value
\strong{increases geocoding speed}. Acceptable values include the full country
name in English or the official language of the country, the two-character
country code, or the three-character country code.
}
}

\section{\code{outsr}}{
The spatial reference can be specified as either a well-known ID (WKID). If
not specified, the spatial reference of the output locations is the same as
that of the service ( WGS84, i.e. WKID = 4326)).

See \link{arc_spatial_references} for values and examples.
}

\examples{
\dontshow{if (arcgeocoder_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
simple <- arc_geo_multi(
  address = "Plaza Mayor", limit = 10,
  custom_query = list(outFields = c("LongLabel", "CntryName", "Region"))
)

library(dplyr)

simple \%>\%
  select(lat, lon, CntryName, Region, LongLabel) \%>\%
  slice_head(n = 10)

# Restrict search to Spain
simple2 <- arc_geo_multi(
  address = "Plaza Mayor", countrycode = "ESP",
  limit = 10,
  custom_query = list(outFields = c("LongLabel", "CntryName", "Region"))
)

simple2 \%>\%
  select(lat, lon, CntryName, Region, LongLabel) \%>\%
  slice_head(n = 10)

# Restrict to a region
simple3 <- arc_geo_multi(
  address = "Plaza Mayor", region = "Segovia",
  countrycode = "ESP",
  limit = 10,
  custom_query = list(outFields = c("LongLabel", "CntryName", "Region"))
)

simple3 \%>\%
  select(lat, lon, CntryName, Region, LongLabel) \%>\%
  slice_head(n = 10)
}
\dontshow{\}) # examplesIf}
}
\references{
\href{https://developers.arcgis.com/rest/geocode/api-reference/geocoding-find-address-candidates.htm}{ArcGIS REST \code{findAddressCandidates}}
}
\seealso{
\code{\link[tidygeocoder:geo]{tidygeocoder::geo()}}

Other functions for geocoding: 
\code{\link{arc_geo}()},
\code{\link{arc_geo_categories}()},
\code{\link{arc_reverse_geo}()}
}
\concept{geocoding}
