% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc_geo.R
\name{arc_geo}
\alias{arc_geo}
\title{Geocoding using the ArcGIS REST API}
\usage{
arc_geo(
  address,
  lat = "lat",
  long = "lon",
  limit = 1,
  full_results = FALSE,
  return_addresses = TRUE,
  verbose = FALSE,
  progressbar = TRUE,
  outsr = NULL,
  langcode = NULL,
  sourcecountry = NULL,
  category = NULL,
  custom_query = list()
)
}
\arguments{
\item{address}{character with single line address
(\code{"1600 Pennsylvania Ave NW, Washington"}) or a vector of addresses
(\code{c("Madrid", "Barcelona")}).}

\item{lat}{latitude column name in the output data (default  \code{"lat"}).}

\item{long}{longitude column name in the output data (default  \code{"lon"}).}

\item{limit}{maximum number of results to return per input address. Note
that each query returns a maximum of 50 results.}

\item{full_results}{returns all available data from the API service. This
is a shorthand of \verb{outFields=*}. See \strong{References}. If \code{FALSE} (default)
only the default values of the API would be returned. See also
\code{return_addresses} argument.}

\item{return_addresses}{return input addresses with results if \code{TRUE}.}

\item{verbose}{if \code{TRUE} then detailed logs are output to the console.}

\item{progressbar}{Logical. If \code{TRUE} displays a progress bar to indicate
the progress of the function.}

\item{outsr}{The spatial reference of the \verb{x,y} coordinates returned by a
geocode request. By default is \code{NULL} (i.e. the parameter won't be used in
the query). See \strong{Details} and \link{arc_spatial_references}.}

\item{langcode}{Sets the language in which reverse-geocoded addresses are
returned.}

\item{sourcecountry}{Limits the candidates returned to the specified country
or countries. Acceptable values include the three-character country code.
You can specify multiple country codes to limit results to more than one
country.}

\item{category}{A place or address type that can be used to filter results.
Several values can be used as well as a vector (i.e.
\code{c("Cinema", "Museum")}). See \link{arc_categories} for details.}

\item{custom_query}{API-specific parameters to be used, passed as a named
list.}
}
\value{
A \code{\link[tibble:tibble]{tibble}} object with the results. See the details of the output in  \href{https://developers.arcgis.com/rest/geocode/api-reference/geocoding-service-output.htm}{ArcGIS REST API Service output}.
}
\description{
Geocodes addresses given as character values. This function returns the
\code{\link[tibble:tibble]{tibble}} object associated with the query.

This function uses the \code{SingleLine} approach detailed in the
\href{https://developers.arcgis.com/rest/geocode/api-reference/geocoding-find-address-candidates.htm}{ArcGIS REST docs}. For multi-field queries (i.e.
using specific address parameters) use \code{\link[=arc_geo_multi]{arc_geo_multi()}} function.
}
\details{
More info and valid values in the \href{https://developers.arcgis.com/rest/geocode/api-reference/geocoding-find-address-candidates.htm}{ArcGIS REST docs}.
}
\section{\code{outsr}}{
The spatial reference can be specified as either a well-known ID (WKID). If
not specified, the spatial reference of the output locations is the same as
that of the service ( WGS84, i.e. WKID = 4326)).

See \link{arc_spatial_references} for values and examples.
}

\examples{
\dontshow{if (arcgeocoder_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
arc_geo("Madrid, Spain")

library(dplyr)

# Several addresses with additional output fields
with_params <- arc_geo(c("Madrid", "Barcelona"),
  custom_query = list(outFields = c("LongLabel", "CntryName"))
)

with_params \%>\%
  select(lat, lon, CntryName, LongLabel)

# With options: restrict search to USA
with_params_usa <- arc_geo(c("Madrid", "Barcelona"),
  sourcecountry = "USA",
  custom_query = list(outFields = c("LongLabel", "CntryName"))
)

with_params_usa \%>\%
  select(lat, lon, CntryName, LongLabel)
}
\dontshow{\}) # examplesIf}
}
\references{
\href{https://developers.arcgis.com/rest/geocode/api-reference/geocoding-find-address-candidates.htm}{ArcGIS REST \code{findAddressCandidates}}.
}
\seealso{
\code{\link[tidygeocoder:geo]{tidygeocoder::geo()}}

Other functions for geocoding: 
\code{\link{arc_geo_categories}()},
\code{\link{arc_geo_multi}()},
\code{\link{arc_reverse_geo}()}
}
\concept{geocoding}
