% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{arc_categories}
\alias{arc_categories}
\title{ArcGIS REST API category data base}
\format{
A \code{\link[tibble:tibble]{tibble}} with
376 rows and
fields:
\describe{
\item{level_1}{Top-level category}
\item{level_2}{Second-level category}
\item{level_3}{Child-level category}
}
}
\source{
\href{https://developers.arcgis.com/rest/geocode/api-reference/geocoding-category-filtering.htm}{ArcGIS REST Category filtering}.
}
\description{
Database of available categories that can be used for filtering results
provided by \code{\link[=arc_geo]{arc_geo()}}, \code{\link[=arc_geo_multi]{arc_geo_multi()}} and \code{\link[=arc_geo_categories]{arc_geo_categories()}} in
\code{\link[tibble:tibble]{tibble}} format.
}
\details{
See \href{https://developers.arcgis.com/rest/geocode/api-reference/geocoding-category-filtering.htm}{ArcGIS REST Category filtering} for details and
examples.

The geocoding service allows users to search for and geocode many types of
addresses and places around the world. This simplifies the application
building process, as developers don't need to know what types of places
their users are searching for, because the service can decipher that.
However, due to this flexibility, it is possible for ambiguous searches to
match to many different places, and users may sometimes receive unexpected
results. For example, a search for a city may match to a street name, or a
search for an airport code may match to a country abbreviation.

For such cases, the service provides the ability to filter out unwanted
geocode results with the \code{category} parameter. The \code{category} parameter
limits the types of places for which the service searches, thus eliminating
false positive matches and potentially speeding up the search process.

The results shows a list of categories with three different hierarchy levels
(\code{level_1}, \code{level_2}, \code{level_3}). If a \code{level_1} category is requested
(i.e. \code{POI}) the child categories may be included also in the results.
}
\note{
Data extracted on \strong{10 January 2023}.
}
\examples{
\dontshow{if (arcgeocoder_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Get all possible values
data("arc_categories")
arc_categories

# Using categories

sea_1 <- arc_geo("sea",
  custom_query = list(outFields = c("LongLabel", "Type")),
  limit = 2
)


dplyr::glimpse(sea_1)

# An airport, but if we use categories...

sea_2 <- arc_geo("sea",
  custom_query = list(outFields = c("LongLabel", "Type")),
  limit = 2, category = "Food"
)

dplyr::glimpse(sea_2)

# We can use a list of categories
sea_3 <- arc_geo("sea",
  custom_query = list(outFields = c("LongLabel", "Type")),
  sourcecountry = "UK", limit = 5,
  category = c("Amusement Park", "Aquarium")
)

dplyr::glimpse(sea_3)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=arc_geo_categories]{arc_geo_categories()}}, \code{\link[=arc_geo]{arc_geo()}}, \code{\link[=arc_geo_multi]{arc_geo_multi()}}

Other datasets: 
\code{\link{arc_spatial_references}}
}
\concept{datasets}
