% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaning.R
\name{sdr}
\alias{sdr}
\alias{sdr.track_xyt}
\title{Calculate SDR for an Object}
\usage{
sdr(x, time_unit = "secs", append_na = TRUE, ...)

\method{sdr}{track_xyt}(x, time_unit = "secs", append_na = TRUE, ...)
}
\arguments{
\item{x}{\verb{[track_xyt]} Object to calculate SDR from. Currently implemented
for \code{track_xyt}.}

\item{time_unit}{\verb{[character]} Character string giving time unit. Should be
\code{"secs"}, \code{"mins"}, or \code{"hours"}.}

\item{append_na}{\verb{[logical]} Should \code{NA} be appended to the end of the vector?
Ensures \code{length(result) == nrow(x)} if appending as a column of \code{x}.}

\item{...}{Further arguments, none implemented.}
}
\description{
Calculates SDR for an object of certain class
}
\details{
\code{time_unit} defaults to seconds because \code{\link{calculate_sdr}()}
returns SDR in m^2/s. We assume the user is also working in a projected
CRS with units in meters, thus we expect SDR in m^2/s to be most relevant.
}
\seealso{
\code{\link{calculate_sdr}()}, \code{\link{get_displacement}()}
}
\author{
Brian J. Smith and Johannes Signer
}
