#'  Discoveries Of Introduced Species In The San Francisco Estuary (California, USA)
#'
#' The data provided by Solow and Costello (2004) describing discoveries of introduced species in the San Francisco estuary (California, USA)
#' between the years 1850–1995. These data were compiled by Cohen and Carlton (1995); see also Cohen and Carlton (1998). \cr
#' \cr
#' The original data in PDF format is described in full in Cohen and Carlton (1995) and can be viewed here: https://repository.library.noaa.gov/view/noaa/40918
#'
#' @references Cohen, A. N., and J. T. Carlton. 1995. Nonindigenous aquatic species in a United States estuary: a case study of the biological invasions of the San Francisco Bay and Delta. U.S. Fish and Wildlife Service, Washington, D.C., USA. https://repository.library.noaa.gov/view/noaa/40918
#' @references Cohen, A. N., and J. T. Carlton. 1998. Accelerating invasion rate in a highly invaded estuary. Science 279: 555– 558. https://www.science.org/doi/10.1126/science.279.5350.555
#' @references Solow, A. R., and Costello, C. J. 2004. Estimating the rate of species introductions from the discovery record. Ecology, 85(7), 1822–1825. https://esajournals.onlinelibrary.wiley.com/doi/abs/10.1890/03-3102
#'
#'
#' @source <https://esajournals.onlinelibrary.wiley.com/doi/abs/10.1890/03-3102>
#' @source <https://repository.library.noaa.gov/view/noaa/40918>
"sfestuary"

#'  Discoveries Of Native And Alien Fish Species In The Eastern Mediterranean Sea
#'
#' The updated data used in Belmaker et al (2009) describing discoveries of native and alien species in the Mediterranean Sea
#' between the years 1927–2017. The original data is described in full in Golani (2005); see also Golani (2021) for the updated version used here.
#'
#' @format
#' A data frame with 60 rows and 4 columns:
#' \describe{
#'   \item{year}{Year of record}
#'   \item{time}{Time since the first record in the records data}
#'   \item{natives}{Number of newly recorded native species in corresponding year}
#'   \item{aliens}{Number of newly recorded alien species in corresponding year}
#' }
#'
#' @references Golani, D. 2005. Checklist of the Mediterranean Fishes of Israel. Zootaxa, 947, 1-90. https://mapress.com/zt/article/view/zootaxa.947.1.1
#' @references Belmaker, J., Brokovich, E., China, V., Golani, D., and Kiflawi, M. 2009. Estimating the rate of biological introductions: Lessepsian fishes in the Mediterranean. Ecology, 90(4), 1134–1141. https://esajournals.onlinelibrary.wiley.com/doi/10.1890/07-1904.1
#' @references Golani, D. 2021. An updated Checklist of the Mediterranean fishes of Israel, with illustrations of recently recorded species and delineation of Lessepsian migrants. Zootaxa, 4956, 1-108. https://www.mapress.com/zt/article/view/zootaxa.4956.1.1
#'
#' @source <https://esajournals.onlinelibrary.wiley.com/doi/abs/10.1890/07-1904.1>
#' @source <https://www.mapress.com/zt/article/view/zootaxa.4956.1.1>
"medfish"
