% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0S4.R, R/simon_pr.R
\docType{class}
\name{simon_pr}
\alias{simon_pr}
\alias{simon_pr-class}
\alias{simon_pr.ph2simon}
\alias{simon_pr.ph2simon4}
\title{Probabilities of one Simon's Two-Stage Design}
\usage{
simon_pr(prob, object, ...)

\method{simon_pr}{ph2simon}(prob, object, ...)

\method{simon_pr}{ph2simon4}(
  prob,
  object,
  r1 = object@r1,
  n1 = object@n1,
  r = object@r,
  n = object@n,
  ...
)
}
\arguments{
\item{prob}{\link[base]{double} scalar or \link[base]{vector},
true response rate(s) \eqn{p}}

\item{object}{a \link[clinfun]{ph2simon} or \linkS4class{ph2simon4} object}

\item{...}{parameters of function \code{\link[=ph2simon4]{ph2simon4()}}, most importantly \code{type}}

\item{r1, n1, r, n}{(optional) \link[base]{integer} scalars, see \linkS4class{ph2simon4}.}
}
\value{
Function \code{\link[=simon_pr]{simon_pr()}} returns \linkS4class{simon_pr} object.
}
\description{
Probabilities of frail
(i.e., early termination) and success (to reject \eqn{H_0})
of \strong{one} Simon's two-stage design, at given true response rate(s).
}
\details{
Given one Simon's two-stage design \eqn{(r_1,n_1,r,n)}
and a true response rate \eqn{p},
we have the number of Stage-1 positive responses \eqn{X_1 \sim \textrm{Binom}(n_1, p)}
and the number of Stage-2 positive responses \eqn{X_2 \sim \textrm{Binom}(n-n_1, p)}.
Obviously \eqn{X_1} and \eqn{X_2} are independent.

The probability of early termination is
\deqn{p_{\textrm{frail}} = \textrm{Pr}(X_1 \leq r_1)}

The probability of failure to reject \eqn{H_0} is
\deqn{\sum_{s_1 = r_1+1}^{n_1} \textrm{Pr}(X_1=s_1)\cdot\textrm{Pr}(X_2 \leq (r-s_1))}

The probability of successfully rejecting \eqn{H_0} is
\deqn{\sum_{s_1 = r_1+1}^{n_1} \textrm{Pr}(X_1=s_1)\cdot\textrm{Pr}(X_2 > (r-s_1))}

The expected sample size is
\deqn{\textrm{E}(n) = p_{\textrm{frail}} \cdot n_1 + (1 - p_{\textrm{frail}}) \cdot n}

Parameters nomenclature of \code{r1}, \code{n1}, \code{r} and \code{n} follows that of
PASS and function \link[clinfun]{ph2simon}.
}
\section{Slots}{

\describe{
\item{\code{frail}}{\link[base]{numeric} scalar or \link[base]{vector},
probabilities of frail (i.e., early termination)
at given true response rate(s) \eqn{p}.}

\item{\code{reject}}{\link[base]{numeric} scalar or \link[base]{vector},
probabilities of success (to reject \eqn{H_0})
at given true response rate(s) \eqn{p}.}

\item{\code{eN}}{\link[base]{numeric} scalar or \link[base]{vector},
expected sample size(s) \eqn{\textrm{E}(n)}
at given true response rate(s) \eqn{p}.}

\item{\code{prob}}{\link[base]{double} scalar or \link[base]{vector}, true response rate(s) \eqn{p}}
}}

\examples{
(x = clinfun::ph2simon(pu = .2, pa = .4, ep1 = .05, ep2 = .1)) 
simon_pr(prob = c(.2, .3, .4), object = x)
simon_pr.ph2simon4(prob = c(.2, .3, .4), r1 = 5L, n1 = 24L, r = 13L, n = 45L) # internal use
}
