% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_estimate_lag.R
\name{estimate_lag}
\alias{estimate_lag}
\title{Estimate Lag Function}
\usage{
estimate_lag(
  time_series1,
  time_series2,
  possible_lags,
  method = c("cross-correlation", "MSE", "rank"),
  leave_off,
  estimated_change = 0,
  order_of_polynomial_approximation = 7,
  order_of_derivative = 1,
  spline = FALSE,
  ...
)
}
\arguments{
\item{time_series1}{A numeric vector which stores the time series of interest in the log scale.}

\item{time_series2}{A numeric vector which stores the trend proxy time series in the log scale. The length of trend_proxy must be the same as that of time_series1.}

\item{possible_lags}{A numeric vector specifying all the candidate lags for trend_proxy. The default option is -36:36.}

\item{method}{A character vector specifying the method used to obtain the lag estimate. "polynomial" uses polynomial approximation, while "cross-correlation" uses cross-correlation.}

\item{leave_off}{A positive integer specifying the number of observations to be left off when estimating the lag.}

\item{estimated_change}{A numeric specifying the estimated change in the visitation trend. The default option is 0, implying no change in the trend.}

\item{order_of_polynomial_approximation}{A numeric specifying the order of the polynomial approximation of the difference between time series used in \code{estimate_lag}. The default option is 7, the seventh-degree polynomial.}

\item{order_of_derivative}{A numeric specifying the order of derivative for the approximated difference between time_series1 and lagged time_series2. The default option is 1, the first derivative.}

\item{spline}{A Boolean specifying whether or not to use a smoothing spline for the lag estimation.}

\item{...}{Additional arguments to be passed onto the \code{smooth.spline} function, if method is "polynomial".}
}
\value{
\item{cc_lag}{A numeric indicating the estimated lag with the cross-correlation criterion.}
\item{mse_criterion}{A numeric indicating the estimated lag with the MSE criterion.}
\item{rank_criterion}{A numeric indicating the estimate lag with the rank criterion.}
}
\description{
Uses polynomial approximation and derivatives for time series objects to estimate lag between series.
}
\examples{
# Generate dataset with known lag and recover this lag --------------#'

lag <- 3
n <- 156
start_year <- 2005
frequency <- 12
trend_function <- function(x) x^2

x <- seq(-3,3, length.out = n)

y1 <- ts(trend_function(x),start = start_year, freq = frequency)
y2 <- stats::lag(y1, k = lag)


# Recover lag
estimate_lag(y1,y2, possible_lags = -36:36,
             method = "rank",leave_off = 0, spline = FALSE)


}
