% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo.R
\name{loo.tridim_transformation}
\alias{loo.tridim_transformation}
\title{Computes an efficient approximate leave-one-out
cross-validation via loo library. It can be used
for a model comparison via loo::loo_compare() function.}
\usage{
\method{loo}{tridim_transformation}(x, ...)
}
\arguments{
\item{x}{A \link[=tridim_transformation-class]{tridim_transformation} object}

\item{...}{unused}
}
\value{
A named list, see \code{\link[loo:loo]{loo::loo()}} for details.
}
\description{
Computes an efficient approximate leave-one-out
cross-validation via loo library. It can be used
for a model comparison via loo::loo_compare() function.
}
\examples{
euc2 <- fit_transformation(depV1+depV2~indepV1+indepV2,
  NakayaData, transformation = 'euclidean')
aff2 <- fit_transformation(depV1+depV2~indepV1+indepV2,
  NakayaData, transformation = 'affine')
loo::loo_compare(loo(euc2), loo(aff2))
}
