% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_generation.R
\name{EnforceOutgroup}
\alias{EnforceOutgroup}
\alias{EnforceOutgroup.phylo}
\alias{EnforceOutgroup.character}
\title{Generate a tree with a specified outgroup}
\usage{
EnforceOutgroup(tree, outgroup)

\method{EnforceOutgroup}{phylo}(tree, outgroup)

\method{EnforceOutgroup}{character}(tree, outgroup)
}
\arguments{
\item{tree}{Either a tree of class \code{phylo}; or (for \code{EnforceOutgroup()})
a character vector listing the names of all the taxa in the tree, from which
a random tree will be generated.}

\item{outgroup}{Character vector containing the names of taxa to include in
the outgroup.}
}
\value{
\code{EnforceOutgroup()} returned a tree of class \code{phylo} where all
outgroup taxa are sister to all remaining taxa, without modifying the
ingroup topology.
}
\description{
\strong{Deprecated.} This function will be removed in a future version of
\pkg{TreeTools}.
Use \code{RootTree()} instead.
}
\details{
Given a tree or a list of taxa, \code{EnforceOutgroup()} rearranged the ingroup
and outgroup taxa such that the two are sister taxa across the root, without
changing the relationships within the ingroup or within the outgroup.
}
\seealso{
For a more robust implementation, see \code{\link[=RootTree]{RootTree()}}, which will
eventually replace this function
(\href{https://github.com/ms609/TreeTools/issues/30}{#30}).

Other tree manipulation: 
\code{\link{AddTip}()},
\code{\link{CollapseNode}()},
\code{\link{ConsensusWithout}()},
\code{\link{DropTip}()},
\code{\link{ImposeConstraint}()},
\code{\link{KeptPaths}()},
\code{\link{KeptVerts}()},
\code{\link{LeafLabelInterchange}()},
\code{\link{MakeTreeBinary}()},
\code{\link{Renumber}()},
\code{\link{RenumberTips}()},
\code{\link{RenumberTree}()},
\code{\link{RootTree}()},
\code{\link{SortTree}()},
\code{\link{Subtree}()},
\code{\link{TipTimedTree}()},
\code{\link{TrivialTree}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree manipulation}
