# TreeRingShape

This **R** package is designed for efficiently recording the shape of all
annual rings in a tree trunk cross-section. It **interpolates the annual
rings (L2)** between **representative annual ring lines (L)** from the
**annual ring points (P)** and **representative annual ring lines**
inputted on radii measured in GIS software ('Qgis'). A **"representative
annual ring"** refers to the annual rings that characterize the shape of
the outer circumference and the cross-section of the disc, requiring
fewer rings the closer their shape is to a perfect circle. Although
annual rings grow concentrically around the pith, their shape is not
perfectly circular. Traditionally, dendrochronology and tree-ring
analysis have evaluated tree growth based on the width of the annual
rings. However, with the advancement of image analysis technologies,
there has been an increasing number of studies evaluating growth based
on the area of the annual rings. Most of these studies have focused on
conifer plantation samples, where the annual rings are clearly defined.
However, this package also enables the recording of annual ring shapes
in trees from natural forests, where the ring shapes are more complex.
It should be noted, however, that currently, information regarding the
shape of the annual rings needs to be manually inputted, which can be
labor-intensive.

![Qgis2R](https://github.com/ishidamgm/TreeRingShape/assets/40332131/0ec0fffb-3f93-40fe-a425-b50c93e1e169)

\*\* see also \*\*
<https://www.sanchikanri.com/treering/TreeRingShape.html>
