% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posteriorPredictive.R
\name{posteriorPredictive}
\alias{posteriorPredictive}
\title{Get Posterior Predictive Samples}
\usage{
posteriorPredictive(
  fittedModel,
  M = 100,
  numItems = NULL,
  expected = FALSE,
  nCPU = 4
)
}
\arguments{
\item{fittedModel}{fitted latent-trait or beta MPT model (\code{\link{traitMPT}}, \code{\link{betaMPT}})}

\item{M}{number of posterior predictive samples. As a maximum, the number of posterior samples in \code{fittedModel} is used.}

\item{numItems}{optional: a vector with the number of items per MPT tree to sample predicted data for a new participant (first, a participant vector \eqn{\theta} is sampled from the hierarchical posterior; second, frequencies are generated).}

\item{expected}{if \code{TRUE}, the expected frequencies per person are returned (without additional sampling from a multinomial distribution)}

\item{nCPU}{number of CPUs used for parallel sampling. For large models and many participants, this requires considerable computer-memory resources (as a remedy, use \code{nCPU=1}).}
}
\value{
by default, a list of \code{M} posterior-predictive samples (i.e., matrices) with individual frequencies (rows=participants, columns=MPT categories). For \code{M=1}, a single matrix is returned. If \code{numItems} is provided, a matrix with samples for a new participant is returned (rows=samples)
}
\description{
Draw predicted frequencies based on posterior distribution of (a) individual estimates (default) or (b) for a new participant (if \code{numItems} is provided; does not consider continuous or discrete predictors in traitMPT).
}
\examples{
\dontrun{
# add posterior predictive samples to fitted model
#     (facilitates plotting using ?plotFit)
fittedModel$postpred$freq.pred <-
  posteriorPredictive(fittedModel, M = 1000)
}
}
