% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProcessHeatdata.R
\name{process_heatdata}
\alias{process_heatdata}
\title{Process Heatmap Data with Various Selection Options}
\usage{
process_heatdata(
  heatdata,
  selection = 1,
  custom_names = NULL,
  num_names_per_group = NULL,
  prefix_length = 4
)
}
\arguments{
\item{heatdata}{A data frame containing the heatmap data.}

\item{selection}{An integer specifying the processing method:
- 1: Use custom names for columns.
- 2: Select a given number of columns per group based on a prefix.
- 3: Calculate the average of columns per group based on a prefix.}

\item{custom_names}{A character vector of custom names for columns (used when `selection = 1`).
The length of this vector must match the number of columns in `heatdata`.}

\item{num_names_per_group}{An integer specifying the number of columns to select per group (used when `selection = 2`).}

\item{prefix_length}{An integer specifying the length of the prefix for grouping columns (used when `selection = 2` or `selection = 3`).
Default is 4.}
}
\value{
A processed data frame based on the specified selection option.
}
\description{
This function processes heatmap data (`heatdata`) based on a given selection option.
It allows customization of column names, selection of specific columns per group,
or averaging columns based on a common prefix.
}
\examples{
# Example heatmap data frame
heatdata <- data.frame(
  groupA_1 = c(1, 2, 3),
  groupA_2 = c(4, 5, 6),
  groupB_1 = c(7, 8, 9),
  groupB_2 = c(10, 11, 12)
)

# Selection 1: Use custom names for columns
custom_names <- c("Sample1", "Sample2", "Sample3", "Sample4")
processed_data1 <- process_heatdata(heatdata, selection = 1, custom_names = custom_names)

# Selection 2: Select a given number of columns per group based on a prefix
processed_data2 <- process_heatdata(heatdata, selection = 2, num_names_per_group = 1)

# Selection 3: Calculate the average of columns per group based on a prefix
processed_data3 <- process_heatdata(heatdata, selection = 3, prefix_length = 6)
}
