% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneHighlights.R
\name{gene_highlights}
\alias{gene_highlights}
\title{Add gene highlights to a ggtree object}
\usage{
gene_highlights(ggtree_obj, genes_to_highlight, hilight_extend = 18)
}
\arguments{
\item{ggtree_obj}{A ggtree object to which the highlights will be added.}

\item{genes_to_highlight}{A data frame containing genes and their corresponding colors.}

\item{hilight_extend}{Integer, the extension of the highlight fan in degrees.}
}
\value{
A ggtree object with added gene highlights.
}
\description{
This function enhances a `ggtree` plot by adding highlights for specific genes. It adds both a semi-transparent fan-shaped
highlight and a point at the node corresponding to each gene. Colors for each gene can be customized.
}
\examples{
data("gtree", package = "TransProR")

# Define genes and their colors
genes_df <- data.frame(Symble = c("t5", "t9"),
                       color = c("#FF0000", "#0000FF"))

# Add highlights
gtree <- gene_highlights(gtree, genes_to_highlight = genes_df)

}
