% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NewGgraph.R
\name{new_ggraph}
\alias{new_ggraph}
\title{Generate a graphical representation of pathway gene maps}
\usage{
new_ggraph(
  BP_dataframe,
  BP_ids,
  KEGG_dataframe,
  KEGG_ids,
  MF_dataframe,
  MF_ids,
  REACTOME_dataframe,
  REACTOME_ids,
  CC_dataframe,
  CC_ids,
  DO_dataframe,
  DO_ids
)
}
\arguments{
\item{BP_dataframe}{Dataframe for Biological Process.}

\item{BP_ids}{IDs for Biological Process.}

\item{KEGG_dataframe}{Dataframe for KEGG pathways.}

\item{KEGG_ids}{IDs for KEGG pathways.}

\item{MF_dataframe}{Dataframe for Molecular Function.}

\item{MF_ids}{IDs for Molecular Function.}

\item{REACTOME_dataframe}{Dataframe for REACTOME pathways.}

\item{REACTOME_ids}{IDs for REACTOME pathways.}

\item{CC_dataframe}{Dataframe for Cellular Component.}

\item{CC_ids}{IDs for Cellular Component.}

\item{DO_dataframe}{Dataframe for Disease Ontology.}

\item{DO_ids}{IDs for Disease Ontology.}
}
\value{
A 'ggraph' object representing the pathway gene map visualization.
}
\description{
This function merges multiple gene-pathway related dataframes, processes them
for graph creation, and visualizes the relationships in a dendrogram layout using
the provided node and edge gathering functions from the 'ggraph' package.
}
\examples{
# Example Biological Process (BP) DataFrame
BP_dataframe <- data.frame(
  ID = c("BP1", "BP2"),
  Description = c("Biological Process 1", "Biological Process 2"),
  geneID = c("GeneA/GeneB/GeneC", "GeneD/GeneE"),
  stringsAsFactors = FALSE
)

# Example KEGG DataFrame
KEGG_dataframe <- data.frame(
  ID = c("KEGG1", "KEGG2"),
  Description = c("KEGG Pathway 1", "KEGG Pathway 2"),
  geneID = c("GeneA/GeneD", "GeneB/GeneF"),
  stringsAsFactors = FALSE
)

# Example Molecular Function (MF) DataFrame
MF_dataframe <- data.frame(
  ID = c("MF1", "MF2"),
  Description = c("Molecular Function 1", "Molecular Function 2"),
  geneID = c("GeneC/GeneE", "GeneF/GeneG"),
  stringsAsFactors = FALSE
)

# Example Reactome DataFrame
REACTOME_dataframe <- data.frame(
  ID = c("REACTOME1", "REACTOME2"),
  Description = c("Reactome Pathway 1", "Reactome Pathway 2"),
  geneID = c("GeneA/GeneF", "GeneB/GeneG"),
  stringsAsFactors = FALSE
)

# Example Cellular Component (CC) DataFrame
CC_dataframe <- data.frame(
  ID = c("CC1", "CC2"),
  Description = c("Cellular Component 1", "Cellular Component 2"),
  geneID = c("GeneC/GeneD", "GeneE/GeneH"),
  stringsAsFactors = FALSE
)

# Example Disease Ontology (DO) DataFrame
DO_dataframe <- data.frame(
  ID = c("DO1", "DO2"),
  Description = c("Disease Ontology 1", "Disease Ontology 2"),
  geneID = c("GeneF/GeneH", "GeneA/GeneI"),
  stringsAsFactors = FALSE
)

# Example IDs vectors for each category
BP_ids <- c("BP1", "BP2")
KEGG_ids <- c("KEGG1", "KEGG2")
MF_ids <- c("MF1", "MF2")
REACTOME_ids <- c("REACTOME1", "REACTOME2")
CC_ids <- c("CC1", "CC2")
DO_ids <- c("DO1", "DO2")

# Running the `new_ggraph` function to plot a graph
plot <- new_ggraph(
  BP_dataframe = BP_dataframe, BP_ids = BP_ids,
  KEGG_dataframe = KEGG_dataframe, KEGG_ids = KEGG_ids,
  MF_dataframe = MF_dataframe, MF_ids = MF_ids,
  REACTOME_dataframe = REACTOME_dataframe, REACTOME_ids = REACTOME_ids,
  CC_dataframe = CC_dataframe, CC_ids = CC_ids,
  DO_dataframe = DO_dataframe, DO_ids = DO_ids
)

}
