% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnrichCirclize.R
\name{enrichment_circlize}
\alias{enrichment_circlize}
\title{Draw Chord Diagram with Legends}
\usage{
enrichment_circlize(
  all_combined_df,
  original_colors,
  labels,
  colors,
  labels2,
  colors2,
  font_size = 10
)
}
\arguments{
\item{all_combined_df}{A dataframe containing the matrix for the chord diagram.}

\item{original_colors}{A vector of colors for the grid columns of the chord diagram.}

\item{labels}{A vector of labels for the first legend.}

\item{colors}{A vector of colors corresponding to the first legend's labels.}

\item{labels2}{A vector of labels for the second legend.}

\item{colors2}{A vector of colors corresponding to the second legend's labels.}

\item{font_size}{The font size used for legend texts, defaults to 10.}
}
\value{
Invisible, primarily used for its side effects of drawing on a graphics device.
}
\description{
This function creates a chord diagram from a specified dataframe and draws two sets of legends for it.
It adjusts the track height of the chord diagram to optimize space and uses specified colors for the grid.
Legends are drawn at specified positions with configurable text alignments and font sizes.
}
\examples{
# Sample Chord Diagram Matrix
all_combined_df <- data.frame(
  A = c(10, 20, 30),
  B = c(15, 25, 35),
  C = c(5, 10, 15)
)
rownames(all_combined_df) <- c("A", "B", "C")

# Colors for the grid of the chord diagram (corresponding to columns of the matrix)
original_colors <- c("red", "green", "blue")

# Name the colors according to the sectors (A, B, C)
names(original_colors) <- colnames(all_combined_df)

# Labels and Colors for the First Legend
labels <- c("Label 1", "Label 2", "Label 3")
colors <- c("yellow", "purple", "cyan")

# Labels and Colors for the Second Legend
labels2 <- c("Label A", "Label B", "Label C")
colors2 <- c("orange", "pink", "brown")

# Font size for the legend texts (optional, default is 10)
font_size <- 10

# Call the enrichment_circlize function with the sample data
# This is just an example; the plot will be rendered in an appropriate graphics context
# such as RStudio's plot pane or an external plotting window.
plot1 <- enrichment_circlize(all_combined_df,
                             original_colors,
                             labels,
                             colors,
                             labels2,
                             colors2,
                             font_size
                             )

}
