% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcSetForLifePnL.R
\name{CalcSetForLifePnL}
\alias{CalcSetForLifePnL}
\title{PnL calculation for Set For Life backtesting}
\usage{
CalcSetForLifePnL(backtested_results, plot_results = FALSE)
}
\arguments{
\item{backtested_results}{The Set For Life results backtested against the user input}

\item{plot_results}{(Optional) If TRUE, the P&L historical graphs are plotted, default FALSE}
}
\value{
PnL figures
}
\description{
Calculates the PnL for a pay out structure created during backtesting
}
\examples{

setforlife_results = SetForLifeResults()
user_input = c(10,20,30,40,50,5)
backtested_results = SetForLifeBacktesting(setforlife_results, date_since='2005-01-01', user_input)
pnl_result = CalcSetForLifePnL(backtested_results, plot_results = FALSE)
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
