% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frailty_sd.R
\name{frailty_sd.AdPaik}
\alias{frailty_sd.AdPaik}
\title{Frailty standard deviation and Variance for the 'Adapted Paik et al.'s Model'}
\usage{
frailty_sd.AdPaik(result, flag_fullsd)
}
\arguments{
\item{result}{S3 object of class 'AdPaik' returned by the main model output, that contains all the information for the computation
of the frailty standard deviation.}

\item{flag_fullsd}{Logical value. Do we want to compute the full frailty standard deviation? If so, the flag must be TRUE,
otherwise, FALSE.}
}
\value{
S3 class object 'FrailtyDispersion' containing both two numerical vectors of length equal to the number of intervals of the time-domain:
\itemize{
\item FrailtyVariance
\item FrailtyStandardDevation
}
}
\description{
The function computes both the standard deviation and the variance of the time-dependent
frailty of the 'Adapted Paik et al.'s Model'.

Recalling the frailty structure \eqn{Z_{jk} = \alpha_j + \epsilon_{jk}} as being composed by a constant group-dependent term
(\eqn{\alpha_j}) and a time and group dependent term (\eqn{\epsilon_{jk}}), the frailty standard deviation (and variance)
can be computed in two different way:
\itemize{
\item Considering only the time-dependent spread of the clusters/groups/centre: \eqn{sd(Z_{jk}) = \mu_2 * \gamma_k}.
In this case, the flag_fullsd should be FALSE.
\item Considering both the time-dependent and constant spread of the clusters: \eqn{sd(Z_{jk}) = \mu_1 * \nu + \mu_2 * \gamma_k}.
The new added term only moves upward the other case and the flag_fullsd should be TRUE.
}

The final case only depends on what we want to observe.
}
\examples{
# Consider the 'Academic Dropout dataset'
data(data_dropout)

# Define the variables needed for the model execution
formula <- time_to_event ~ Gender + CFUP + cluster(group)
time_axis <- c(1.0, 1.4, 1.8, 2.3, 3.1, 3.8, 4.3, 5.0, 5.5, 5.8, 6.0)
eps <- 1e-10
categories_range_min <- c(-8, -2, eps, eps, eps)
categories_range_max <- c(-eps, 0, 1 - eps, 1, 10)

\donttest{
# Call the main model
result <- AdPaikModel(formula, data_dropout, time_axis,
                      categories_range_min, categories_range_max, TRUE)

frailty_sd(result, TRUE)
frailty_sd(result, FALSE)
}
}
