% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_dummy_variables.R
\name{extract_dummy_variables}
\alias{extract_dummy_variables}
\title{Transform categorical covariate into dummy variables}
\usage{
extract_dummy_variables(covariate, covariate_name)
}
\arguments{
\item{covariate}{Categorical dataset covariate, with at least 2 levels.}

\item{covariate_name}{Name of the covariate, for assigning each dummy variable a proper name.}
}
\value{
S3 object of class 'DummyData', composed of three elements. See details.
}
\description{
This function produces for a categorical variable of the dataset (covariate) the associated dummy variables: for n levels of the covariate,
(n-1) dummy binary variables are generated. The chosen reference value is the first one of the list of extracted levels and cannot be changed
(the first one in alphabetical order). Therefore, if an individual has null value for all dummy variables, then his/her belonging level is the
reference one.

Each dummy variable has a name, corresponding to the name of the covariate + name of the level.
}
\details{
The S3 class object 'DummyData' contains the variables related to the transformation of a single categorical covariate present in the dataset
into (n-1) binary covariates, stored in a matrix. To be precise:
\itemize{
\item DummyMatrix: binary matrix of dimension (n_individuals, n-1), where each column corresponds to one level of the original categorical
covariate.
\item DummyVariablesName: categorical vector of length (n-1), reporting the names of the dummy variables and, therefore, the new name of each regressor.
\item DummyVariablesNumber: number of dummy variables (n-1).
}
}
