% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateTestTable.R
\name{generateTestTables}
\alias{generateTestTables}
\title{Generates an Excel file with sheets that correspond to an OMOP-CDM tables.}
\usage{
generateTestTables(
  tableNames,
  cdmVersion,
  outputFolder,
  filename = paste0("test_cdm_", cdmVersion)
)
}
\arguments{
\item{tableNames}{A list specifying the table names to include in the Excel file.}

\item{cdmVersion}{The CDM version to use for creating the requested tables (either 5.3 or 5.4).}

\item{outputFolder}{The folder where the Excel file will be saved.}

\item{filename}{The name of the Excel file. It does not include the extension .xlsx.}
}
\value{
An Excel file with the tables requested.
}
\description{
Generates an Excel file with sheets that correspond to an OMOP-CDM tables.
}
