% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPC_BIC.R
\name{TPC_BIC}
\alias{TPC_BIC}
\title{Variable Selection via Thresholded Partial Correlation}
\usage{
TPC_BIC(y, x, s = 0.05, constant = 1, method = "threshold")
}
\arguments{
\item{y}{response vector;}

\item{x}{covariate matrix;}

\item{s}{a value or a vector that used as significance level(s) for partial
correlation test. BIC will be used to select the best \code{s}.}

\item{constant}{a value or a vector that used as the tuning constant for partial
correlation test. BIC will be used to select the best \code{constant}.
\code{constant} is treated as 1 when method is "simple".}

\item{method}{the method to be used; default set as method = "threshold";
"simple" is also available.}
}
\value{
TPC.object a TPC object, which extends the \code{lm} object. New attributes are:
\itemize{
\item beta - the fitted coefficients
\item selected_index - the selected coefficients indices
}
}
\description{
Use BIC to select the best \code{s} and \code{constant} over grids.
}
\examples{
#generate sample data
p = 200
n = 200
truebeta <- c(c(3,1.5,0,0,2),rep(0,p-5))
rho = 0.3
sigma =  matrix(0,p+1,p+1)
for(i in 1:(p+1)){
  for(j in 1:(p+1)){
    sigma[i,j] = rho^(abs(i-j))
  }
}
x_error = 0.9*MASS::mvrnorm(n,rep(0,p+1),sigma) + 0.1*MASS::mvrnorm(n,rep(0,p+1),9*sigma)
x = x_error[,1:p]
error = x_error[,p+1]
y = x\%*\%truebeta + error

#perform variable selection via partial correlation
TPC.fit = TPC_BIC(y,x,0.05,c(1,1.5),method="threshold")
TPC.fit$beta


}
