% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interGradientsDL.R
\name{topGradientsCellType}
\alias{topGradientsCellType}
\title{Get top genes with largest/smallest gradients per cell type}
\usage{
topGradientsCellType(object, method = "class", top.n.genes = 15)
}
\arguments{
\item{object}{\code{\linkS4class{SpatialDDLS}} object with a
\code{\linkS4class{DeconvDLModel}} object containing gradients in the
\code{interpret.gradients} slot.}

\item{method}{Method gradients were calculated by. It can be either
\code{'class'} (gradients of predicted classes w.r.t. inputs) or
\code{'loss'} (gradients of loss w.r.t. input features).}

\item{top.n.genes}{Top n genes (positive and negative) taken per cell type.}
}
\value{
List of gene names with the top positive and negative
gradients per cell type.
}
\description{
Retrieve feature names with the largest/smallest gradients per cell
type. These genes can be used to visualize their spatial expression
in the ST data (\code{plotGeneSpatial} function) or to plot the calculated
gradients as a heatmap (\code{plotGradHeatmap} function).
}
\examples{
\donttest{
set.seed(123)
sce <- SingleCellExperiment::SingleCellExperiment(
  assays = list(
    counts = matrix(
      rpois(30, lambda = 5), nrow = 15, ncol = 10,
      dimnames = list(paste0("Gene", seq(15)), paste0("RHC", seq(10)))
    )
  ),
  colData = data.frame(
    Cell_ID = paste0("RHC", seq(10)),
    Cell_Type = sample(x = paste0("CellType", seq(2)), size = 10,
                       replace = TRUE)
  ),
  rowData = data.frame(
    Gene_ID = paste0("Gene", seq(15))
  )
)
SDDLS <- createSpatialDDLSobject(
  sc.data = sce,
  sc.cell.ID.column = "Cell_ID",
  sc.gene.ID.column = "Gene_ID",
  sc.filt.genes.cluster = FALSE
)
SDDLS <- genMixedCellProp(
  object = SDDLS,
  cell.ID.column = "Cell_ID",
  cell.type.column = "Cell_Type",
  num.sim.spots = 50,
  train.freq.cells = 2/3,
  train.freq.spots = 2/3,
  verbose = TRUE
)
SDDLS <- simMixedProfiles(SDDLS)
SDDLS <- trainDeconvModel(
  object = SDDLS,
  batch.size = 12,
  num.epochs = 5
)
## calculating gradients
SDDLS <- interGradientsDL(SDDLS)
listGradients <- topGradientsCellType(SDDLS)
lapply(listGradients, head, n = 5)
}
  
}
\seealso{
\code{\link{interGradientsDL}} \code{\link{trainDeconvModel}}
}
