% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatPCA.R
\name{predictEigenfunction}
\alias{predictEigenfunction}
\title{Spatial dominant patterns on new locations}
\usage{
predictEigenfunction(spatpca_object, x_new)
}
\arguments{
\item{spatpca_object}{An \code{spatpca} class object}

\item{x_new}{New location matrix.}
}
\value{
{A matrix with K Eigenfunction values on new locations.}
}
\description{
Estimate K eigenfunctions on new locations
}
\examples{
# 1D: artificial irregular locations
x_1D <- as.matrix(seq(-5, 5, length = 10))
Phi_1D <- exp(-x_1D^2) / norm(exp(-x_1D^2), "F")
set.seed(1234)
Y_1D <- rnorm(n = 100, sd = 3) \%*\% t(Phi_1D) + matrix(rnorm(n = 100 * 10), 100, 10)
rm_loc <- sample(1:10, 2)
x_1Drm <- x_1D[-rm_loc]
Y_1Drm <- Y_1D[, -rm_loc]
x_1Dnew <- as.matrix(seq(-5, 5, length = 20))
cv_1D <- spatpca(x = x_1Drm, Y = Y_1Drm, tau2 = 1:100, num_cores = 2)
dominant_patterns <- predictEigenfunction(cv_1D, x_new = x_1Dnew)

}
\seealso{
\link{spatpca}
}
