% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isValidST.R
\name{isValidST}
\alias{isValidST}
\title{Check for valid taxonomic level (Order, Suborder, Great Group, Subgroup)}
\usage{
isValidST(needle, level = c("order", "suborder", "greatgroup", "subgroup"))
}
\arguments{
\item{needle}{vector of taxa}

\item{level}{single level of Soil Taxonomy hierarchy; one of: \code{"order"}, \code{"suborder"}, \code{"greatgroup"}, \code{"subgroup"}}
}
\value{
\code{logical} vector, same length as needle
}
\description{
Checks \code{needle} for matches against a single level of Soil Taxonomy hierarchy: \code{order}, \code{suborder}, \code{greatgroup}, \code{subgroup}. Matches are case-insensitive.
}
\examples{

isValidST('typic haploxeralfs', level = 'subgroup')

}
