% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_getDay_ISO8601_week.R
\name{getDay_ISO8601_week}
\alias{getDay_ISO8601_week}
\title{Retrieves the date of the monday in a ISO8601 week-string}
\usage{
getDay_ISO8601_week(
  theweek,
  day = c("Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun")
)
}
\arguments{
\item{theweek}{the string with the week name}

\item{day}{the weekday that shall be returned}
}
\value{
the date of the weekday in the given week
}
\description{
Example date formats defined by ISO 8601:
 * Single days are written in yyy-mm-dd (y: year, m: month, d: day); e.g., 2016-07-19
 * Weeks are written in yyyy-Www; e.g., 2016-W29
}
\details{
The function uses format und as.Date internally and can therefore not handle ISO8601
 week formats. Therefore, a workaround is implemented that can lead to suspicious
 behavior in future versions
}
\author{
Konstantin Hopf \email{konstantin.hopf@uni-bamberg.de}
}
