% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Celltype_Annotation_Heatmap.R
\name{Celltype_Annotation_Heatmap}
\alias{Celltype_Annotation_Heatmap}
\title{Uses "marker_list" to generate heatmap for cell annotation}
\usage{
Celltype_Annotation_Heatmap(
  seurat_obj,
  gene_list,
  species,
  cluster_col = "seurat_clusters",
  assay = "RNA",
  min_expression = 0.1,
  specificity_weight = 3,
  colour_low = "navy",
  colour_high = "firebrick3"
)
}
\arguments{
\item{seurat_obj}{Enter the Seurat object with annotation columns such as
"seurat_cluster" in meta.data to be annotated.}

\item{gene_list}{A list of cells and corresponding gene controls, the name of
the list is cell type, and the first column of the list corresponds to markers.
Lists can be generated using functions such as "Markers_filter_Cellmarker2 ()",
"Markers_filter_PanglaoDB ()", "read_excel_markers ()", "read_seurat_markers ()", etc.}

\item{species}{This parameter selects the species "Human" or "Mouse" for standard
gene format correction of markers entered by "Marker_list".}

\item{cluster_col}{Enter annotation columns such as "seurat_cluster" in meta.data
of the Seurat object to be annotated. Default parameters use "cluster_col =
'seurat_clusters'".}

\item{assay}{Enter the assay used by the Seurat object, such as "RNA". Default
parameters use "assay = 'RNA'".}

\item{min_expression}{The min_expression parameter defines a threshold value to
determine whether a cell's expression of a feature is considered "expressed"
or not. It is used to filter out low-expression cells that may contribute
noise to the analysis. Default parameters use "min_expression = 0.1".}

\item{specificity_weight}{The specificity_weight parameter controls how much the
expression variability (standard deviation) of a feature within a cluster
contributes to its "specificity score." It amplifies or suppresses the impact
of variability in the final score calculation.Default parameters use
"specificity_weight = 3".}

\item{colour_low}{Color for lowest probability level in Heatmap visualization of
probability matrix. (default = "navy")}

\item{colour_high}{Color for highest probability level Heatmap visualization of
probability matrix. (default = "firebrick3")}
}
\value{
The heatmap of the comparison between "cluster_col" in the
Seurat object and the given gene set "gene_list" needs to be annotated.
}
\description{
Uses "marker_list" to generate heatmap for cell annotation
}
\examples{
\dontrun{
Celltype_Annotation_Heatmap(seurat_obj = sce,
    gene_list = Markers_list,
    species = "Human",
    cluster_col = "seurat_clusters",
    assay = "RNA",
    min_expression = 0.1,
    specificity_weight = 3,
    colour_low = "navy",
    colour_high = "firebrick3"
    )
    }

}
\seealso{
Other Section_4_Semi_Automated_Annotation_Workflow: 
\code{\link{Celltype_Annotation_Combined}()},
\code{\link{Celltype_Annotation_Features}()}
}
\concept{Section_4_Semi_Automated_Annotation_Workflow}
