% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleSize_Mielke.R
\name{power_Mielke}
\alias{power_Mielke}
\title{Power Calculation for Hypothesis Testing in Equivalence Trials}
\usage{
power_Mielke(
  N,
  m,
  k,
  R,
  sigma,
  true.diff,
  equi.tol = log(1.25),
  design,
  alpha = 0.05,
  adjust = "no",
  nsim = 10000
)
}
\arguments{
\item{N}{Integer specifying the number of subjects per sequence.}

\item{m}{Integer specifying the number of endpoints.}

\item{k}{Integer specifying the number of endpoints that must meet equivalence
to consider the test successful.}

\item{R}{Matrix specifying the correlation structure between endpoints.
This should be an \code{m x m} matrix, e.g., generated using \code{variance.const.corr()}.}

\item{sigma}{Numeric specifying the standard deviation of endpoints.
Can be a vector of length \code{m} (one per endpoint) or a single value.
In a 2x2 crossover design, this represents within-subject variance.
In a parallel-group design, it represents the treatment group standard deviation.}

\item{true.diff}{Numeric specifying the assumed true difference between test and reference.
Can be a vector of length \code{m} or a single value.}

\item{equi.tol}{Numeric specifying the equivalence margins, with the interval defined as
\code{(-equi.tol, +equi.tol)}. Default is \code{log(1.25)}.}

\item{design}{Character specifying the study design.
Options are \code{"22co"} for a 2x2 crossover design or \code{"parallel"} for a parallel-group design.}

\item{alpha}{Numeric specifying the significance level. Default is \code{0.05}.}

\item{adjust}{Character specifying the method for multiplicity adjustment.
Options include \code{"no"} for no adjustment, \code{"bon"} for Bonferroni correction,
and \code{"k"} for k-adjustment.}

\item{nsim}{Integer specifying the number of simulations to perform. Default is \code{10,000}.}
}
\value{
A numeric value representing the estimated power based on the simulations.
}
\description{
Estimates the power of hypothesis testing in equivalence trials using
the method described by Mielke et al. This approach accounts for multiple
endpoints, correlation structures, and multiplicity adjustments.
}
\keyword{internal}
