% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tabu_addparam.R
\name{add.param}
\alias{add.param}
\title{Adds a parameter to the given search table. Checks whether parameter
is involved in any (in)equality constraints in a fitted lavaan model}
\usage{
add.param(fitted.model, ptab, syntax, nullval = NULL, free = NULL,
  block = NULL)
}
\arguments{
\item{fitted.model}{fitted lavaan model}

\item{ptab}{search table}

\item{syntax}{model.syntax specifying the parameter to add to the current table}

\item{nullval}{optional numeric value specifying what the parameter should be fixed to (when fixed)}

\item{free}{optional logical value specifying whether the parameter should initially be set free (or not)}

\item{block}{optional numeric value specifying the group number to which the parameter corresponds}
}
\value{
A \code{data.frame} with lavaan-formatted parameter values.
}
\description{
Adds a parameter to the given search table. Checks whether parameter
is involved in any (in)equality constraints in a fitted lavaan model
}
\examples{
\dontrun{
# load simulation data and select columns used in this example
data(simulated_test_data) 
tabuData <- simulated_test_data[,c(1:10)]

# specify an improper model (improper because data is unidimensional)
tabuModel <- "
Ability =~ Item1 + Item2 + Item3 + Item4
FakeAbility =~ Item5 + Item6 + Item7 + Item8
Ability ~ Outcome
FakeAbility ~ 0*Outcome"

# run the initial misspecified model for Tabu

init.model <- lavaan::lavaan(model = tabuModel, data = tabuData, 
auto.var=TRUE, auto.fix.first=FALSE, std.lv=TRUE,auto.cov.lv.x=TRUE)

# Use search.prep to prepare for the Tabu search
ptab <- search.prep(fitted.model = init.model,loadings=TRUE,fcov=TRUE,errors=FALSE)

# add an additional (mispecified) parameter
additional.param <- 'Item1 ~~ 0.5*Item3'
ptab <- add.param(fitted.model = init.model, ptab = ptab, syntax = additional.param)

# Perform Tabu Search
trial <- tabu.sem(init.model = init.model, ptab = ptab, obj = AIC, niter = 2, tabu.size = 5) 
}

}
\references{
\url{https://doi.org/10.1080/10705511.2017.1409074}
}
\seealso{
Other Tabu Search: \code{\link{refit.model}},
  \code{\link{search.prep}}
}
\author{
Carl F. Falk
}
